

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;


public class NonVaMedBuilderFactory
    implements
    NonVAMedsBuilderFactoryInterface
{
    private NonVaMedBuilder nonVaMedBuiler = new NonVaMedBuilder();


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildClinicalDomainEventData( clinicalData, cnt, patientIdentifier );
    }

    @Override
    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildNonVAMedsData( clinicalData, recordIdentifier, recordStatus );
    }
    
    public void buildNonVAMedsData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        //determine if we need a record identifier for an Update template else it will be excluded for a create xml 
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );

        Element patient = rootElement.element( "patient" );

        Element patientEnteredVitalSigns = nonVaMedBuiler.makeNonVaMedicationEvents( recordIdentifier, recordStatus );

        patient.add( patientEnteredVitalSigns );
    }



    private void buildClinicalDomainEventData( Document clinicalData, int count, Element patientIdentifer )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );

        List<Element> clinicalDocumentEvents = nonVaMedBuiler.makeNonVaMedicationEvents( count, patientIdentifer );

        for ( Element clinicalDocumentEvent : clinicalDocumentEvents )
        {
            patient.add( clinicalDocumentEvent );
        }
    }


    public void setNonVaMedBuiler( NonVaMedBuilder nonVaMedBuiler )
    {
        this.nonVaMedBuiler = nonVaMedBuiler;
    }
    
    public void setBuilder( AbstractEntryPointBuilder builder )
    {    
        setNonVaMedBuiler((NonVaMedBuilder)builder);
    }
}
