

package gov.va.med.cds.testharness.vhim400.builders;


import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class HAPainReassessmentBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private String recordIdentifier;
    private String painReassessmentDate;
    private int IDX;


    public HAPainReassessmentBuilder( )
    {
        super();
    }


    public HAPainReassessmentBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAPainReassessmentBuilder( String recordIdentifier, String painReassessmentDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.painReassessmentDate = painReassessmentDate;
    }


    public HAPainReassessmentBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makePainReassessments( int number )
    {
        return makePainReassessments( number, null );
    }


    public List<Element> makePainReassessments( int number, Element patient )
    {
        return makePainReassessments( number, patient, true );
    }


    public List<Element> makePainReassessments( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makePainReassessment( "painReassessment", patient, updateRecordXml ) );
        }

        return journalEntry;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makePainReassessment( "patientJournalEntry", personIdentifier );
    }


    public Element makePainReassessment( String elementName, Element patientIdentifier )
    {
        return makePainReassessment( elementName, patientIdentifier, false );
    }


    /**
    <xsd:complexType name="PainReassessment">
        <xsd:all>
            <xsd:element name="patient" type="common:PatientLite"/>
            <xsd:element name="assessmentDate" type="basedatatypes:PointInTime"/>
            <xsd:element name="reassessmentDate" type="basedatatypes:PointInTime"/>
            <xsd:element name="avgPainLevel" type="xsd:anyType"/>
            <xsd:element name="maxPainLevel" type="xsd:anyType"/>
            <xsd:element name="minPainLevel" type="xsd:anyType"/>
            <xsd:element name="painInterference" type="xsd:anyType"/>
            <xsd:element name="painImpactOnMood" type="xsd:anyType"/>
            <xsd:element name="painImpactOnWork" type="xsd:anyType" minOccurs="0"/>
            <xsd:element name="decreaseInSocial" type="xsd:anyType"/>
            <xsd:element name="impressionOfChange" type="common:ZeroToTenRating"/>
            <xsd:element name="sleepRefreshment" type="xsd:anyType"/>
            <xsd:element name="concernOfPainEnding" type="xsd:anyType"/>
            <xsd:element name="concernOfPainTolerance" type="xsd:anyType"/>
            <xsd:element name="concernOfExcersizeInjury" type="xsd:anyType"/>
            <xsd:element name="depressionLevel" type="xsd:anyType"/>
            <xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier"/>
            <xsd:element name="recordVersion" type="xsd:integer" minOccurs="0"/>
            <xsd:element name="recordUpdateTime" type="basedatatypes:PointInTime" minOccurs="0"/>
            <xsd:element name="dataEnterer" type="xsd:string" minOccurs="0"/>
            <xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
        </xsd:all>
    </xsd:complexType>
     */
    public Element makePainReassessment( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPainReassessmentEntry = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( patientIdentifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );
        }

        newPainReassessmentEntry.add( newPatient );

        Element newAssessmentDate = createFixedPointInTime( "assessmentDate" );
        newPainReassessmentEntry.add( newAssessmentDate );

        Element newPainReassessmentDate = ( this.painReassessmentDate != null ) ? createPointInTime( "reassessmentDate", this.painReassessmentDate )
                        : createFixedPointInTime( "reassessmentDate" );
        newPainReassessmentEntry.add( newPainReassessmentDate );

        Element newAvgPainLevelEntry = DocumentHelper.createElement( "avgPainLevel" );
        newAvgPainLevelEntry.addElement( "rating" ).addText( "5" );
        newAvgPainLevelEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newAvgPainLevelEntry );

        Element newMaxPainLevelEntry = DocumentHelper.createElement( "maxPainLevel" );
        newMaxPainLevelEntry.addElement( "rating" ).addText( "5" );
        newMaxPainLevelEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newMaxPainLevelEntry );

        Element newMinPainLevelEntry = DocumentHelper.createElement( "minPainLevel" );
        newMinPainLevelEntry.addElement( "rating" ).addText( "5" );
        newMinPainLevelEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newMinPainLevelEntry );

        Element newPainInterferenceEntry = DocumentHelper.createElement( "painInterference" );
        newPainInterferenceEntry.addElement( "rating" ).addText( "5" );
        newPainInterferenceEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newPainInterferenceEntry );

        Element newPainImpactOnMoodEntry = DocumentHelper.createElement( "painImpactOnMood" );
        newPainImpactOnMoodEntry.addElement( "rating" ).addText( "5" );
        newPainImpactOnMoodEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newPainImpactOnMoodEntry );

        Element newPainImpactOnWorkEntry = DocumentHelper.createElement( "painImpactOnWork" );
        newPainImpactOnWorkEntry.addElement( "rating" ).addText( "5" );
        newPainImpactOnWorkEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newPainImpactOnWorkEntry );

        Element newDecreaseInSocialEntry = DocumentHelper.createElement( "decreaseInSocial" );
        newDecreaseInSocialEntry.addElement( "rating" ).addText( "5" );
        newDecreaseInSocialEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newDecreaseInSocialEntry );

        Element newImpressionOfChangeEntry = DocumentHelper.createElement( "impressionOfChange" );
        newImpressionOfChangeEntry.addElement( "rating" ).addText( "5" );
        newImpressionOfChangeEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newImpressionOfChangeEntry );

        Element newSleepRefreshmentEntry = DocumentHelper.createElement( "sleepRefreshment" );
        newSleepRefreshmentEntry.addElement( "rating" ).addText( "5" );
        newSleepRefreshmentEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newSleepRefreshmentEntry );

        Element newDepressionLevelEntry = DocumentHelper.createElement( "depressionLevel" );
        newDepressionLevelEntry.addElement( "rating" ).addText( "5" );
        newDepressionLevelEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newDepressionLevelEntry );

        Element newConcernOfPainEndingEntry = DocumentHelper.createElement( "concernOfPainEnding" );
        newConcernOfPainEndingEntry.addElement( "rating" ).addText( "5" );
        newConcernOfPainEndingEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newConcernOfPainEndingEntry );

        Element newConcernOfPainToleranceEntry = DocumentHelper.createElement( "concernOfPainTolerance" );
        newConcernOfPainToleranceEntry.addElement( "rating" ).addText( "5" );
        newConcernOfPainToleranceEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newConcernOfPainToleranceEntry );

        newPainReassessmentEntry.addElement( "dataEnterer" ).addText( "dataEnterer" );
        
        newPainReassessmentEntry.addElement( "allowAccessByClinicalStaff" ).addText( "true" );

        Element newConcernOfExcersizeInjuryEntry = DocumentHelper.createElement( "concernOfExerciseInjury" );
        newConcernOfExcersizeInjuryEntry.addElement( "rating" ).addText( "5" );
        newConcernOfExcersizeInjuryEntry.addElement( "question" ).addText( "Question" );
        newPainReassessmentEntry.add( newConcernOfExcersizeInjuryEntry );

        if ( updateRecordXml )
        {
            if ( recordIdentifier != null )
            {
                Element element = DocumentHelper.createElement( "recordIdentifier" );
                element.addElement( "identity" ).addText( recordIdentifier );
                element.addElement( "namespaceId" ).addText( "NamespaceId" );
                element.addElement( "universalId" ).addText( "UniversalId" );
                element.addElement( "universalIdType" ).addText( "UniversalIdType" );
                newPainReassessmentEntry.add( element );
            }
            else
            {
                Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", IDX );
                newPainReassessmentEntry.add( newRecordIdentifier );
            }
        }

        return newPainReassessmentEntry;
    }


    public Element makePainReassessment( String elementName, String recordIdentifier, String recordStatus )
    {
        Element newPainReassessments = DocumentHelper.createElement( elementName );
        Element newPainReassessment = DocumentHelper.createElement( "painReassessment" );

        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        newPainReassessment.add( newRecordIdentifier );

        newPainReassessment.addElement( "recordStatus" ).addText( recordStatus );
        newPainReassessments.add( newPainReassessment );

        return newPainReassessments;
    }


    public Element makePainReassessment( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element newPainReassessments = DocumentHelper.createElement( "painReassessments" );
        List<Element> painReassessmentList = makePainReassessments( countObservations, patientIdentifier, updateRecordXml );
        for ( Element painReassessment : painReassessmentList )
        {
            newPainReassessments.add( painReassessment );
        }

        return newPainReassessments;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        // TODO Auto-generated method stub
        return null;
    }

}
