

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;


public class HAPainEventBuilderFactory
    implements
        HAClinicalDomainBuilderFactoryInterface
{
    private HAPainEventBuilder painEventBuilder = null;


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildDomainData( clinicalData, cnt, patientIdentifier );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildDomainData( clinicalData, recordIdentifier, recordStatus );
    }


    private void buildDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element( "patient" );
        Element newPainEvents = painEventBuilder.makePainEvent( "painEvents", recordIdentifier, recordStatus );
        patient.add( newPainEvents );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;
        Element patient = rootElement.element( "patient" );
        Element newPainEvents = painEventBuilder.makePainEvent( patientIdentifier, count, updateRecordXml );
        patient.add( newPainEvents );
    }


    @Override
    public void setBuilder( AbstractEntryPointBuilder builder )
    {
        setPainEventBuilder( ( HAPainEventBuilder )builder );
    }


    public HAPainEventBuilder getPainEventBuilder( )
    {
        return painEventBuilder;
    }


    public void setPainEventBuilder( HAPainEventBuilder painEventBuilder )
    {
        this.painEventBuilder = painEventBuilder;
    }
}
