

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;


public class HAGoalTrackingBuilderFactory
    implements
        HATrackingClinicalDomainBuilderFactoryInterface
{
    private HAGoalTrackingBuilder goalTrackingBuilder = null;


    @Override
    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildDomainData( clinicalData, cnt, patientIdentifier );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildDomainData( clinicalData, recordIdentifier, recordStatus );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, int count, Element patientIdentifier, String goalName )
    {
        buildDomainData( clinicalData, count, patientIdentifier, goalName );
    }


    @Override
    public void createClinicalDomainData( Document clinicalData, int count, Element patientIdentifier, String goalName, String entryDate )
    {
        buildDomainData( clinicalData, count, patientIdentifier, goalName, entryDate );
    }


    private void buildDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element( "patient" );
        Element newGoalsTracking = goalTrackingBuilder.makeGoalTracking( "goalsTracking", recordIdentifier, recordStatus );
        patient.add( newGoalsTracking );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;
        Element patient = rootElement.element( "patient" );
        Element newGoalsTracking = goalTrackingBuilder.makeGoalTracking( patientIdentifier, count, updateRecordXml );
        patient.add( newGoalsTracking );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier, String goalName )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;
        Element patient = rootElement.element( "patient" );
        if ( goalName != null )
        {
            goalTrackingBuilder.setGoalName( goalName );
        }
        Element newGoalsTracking = goalTrackingBuilder.makeGoalTracking( patientIdentifier, count, updateRecordXml );
        patient.add( newGoalsTracking );
    }


    private void buildDomainData( Document clinicalData, int count, Element patientIdentifier, String goalName, String entryDate )
    {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;
        Element patient = rootElement.element( "patient" );
        if ( goalName != null )
        {
            goalTrackingBuilder.setGoalName( goalName );
        }
        if ( entryDate != null )
        {
            goalTrackingBuilder.setGoalEntryDate( entryDate );
        }
        Element newGoalsTracking = goalTrackingBuilder.makeGoalTracking( patientIdentifier, count, updateRecordXml );
        patient.add( newGoalsTracking );
    }


    @Override
    public void setBuilder( AbstractEntryPointBuilder builder )
    {
        setGoalTrackingBuilder( ( HAGoalTrackingBuilder )builder );
    }


    public HAGoalTrackingBuilder getGoalTrackingBuilder( )
    {
        return goalTrackingBuilder;
    }


    public void setGoalTrackingBuilder( HAGoalTrackingBuilder goalTrackingBuilder )
    {
        this.goalTrackingBuilder = goalTrackingBuilder;
    }
}
