package gov.va.med.cds.testharness.vhim400.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HADietJournalBuilder extends AbstractEntryPointBuilder {
	
	
	private int IDX;
	private String recordIdentifier;
	private String physicalQty;
	private String attachmentName;
	
	public HADietJournalBuilder(String recordIdentifier, String physicalQty, String attachmentName)
	{
		super();
		this.recordIdentifier = recordIdentifier;
		this.physicalQty = physicalQty;
		this.attachmentName=attachmentName;
	}
	
	public HADietJournalBuilder(String recordIdentifier, String physicalQty)
	{
		this(recordIdentifier,physicalQty,null );
	}
	
	public HADietJournalBuilder( )
    {
        super();
    }

	
	public HADietJournalBuilder( Random random )
    {
        super( random );
    }
	
	public HADietJournalBuilder( String recordIdentifier)
	{
		super();
        this.recordIdentifier = recordIdentifier;
	}

	
	public List<Element> makeJournalEntries( int number )
    {
        return makeJournalEntries( number, null );
    }
	
	
	 public List<Element> makeJournalEntries( int number, Element patient )
	    {
	        return makeJournalEntries( number, patient, true );
	    }
	 
	 
	 public List<Element> makeJournalEntries( int number, Element patient, boolean updateRecordXml )
	    {
	        List<Element> journalEntry = new ArrayList<Element>( number );
	        for ( int i = 0; i < number; i++ )
	        {
	            journalEntry.add( makeJournalEntry( "patientjournaling:patientEnteredDietJournalEntry", patient, updateRecordXml ) );
	        }

	        return journalEntry;
	    }
	 
	 

	 @Override
	 public Element createEntryPointRecord( Element personIdentifier )
	    {
	        return makeJournalEntry( "patientjournaling:patientEnteredDietJournalEntry", personIdentifier );
	    }
	 
	 
	 
	 public Element makeJournalEntry( String elementName, Element patientIdentifier )
	    {
	        return makeJournalEntry( elementName, patientIdentifier, false);
	    }
	 
	 
	 
	/* <xsd:complexType name="DietJournalEntry">
		<xsd:complexContent>
			<xsd:extension base="patientjournaling:PatientJournalEntry">
				<xsd:all>
					<xsd:element name="mealType" type="xsd:anyType" minOccurs="0"/>
					<xsd:element name="timeOfMeal" type="basedatatypes:PointInTime" minOccurs="0"/>
					<xsd:element name="mealDescription" type="xsd:string" minOccurs="0"/>
					<xsd:element name="calories" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
					<xsd:element name="fat" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
					<xsd:element name="carbohydrates" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
					<xsd:element name="protein" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>
					<xsd:element name="genericJournalEntryDetails" type="patientjournaling:BasicJournalEntry" minOccurs="0"/>
				</xsd:all>
			</xsd:extension>
		</xsd:complexContent>
	</xsd:complexType>
*/
	 public Element makeJournalEntry( String elementName, Element patientIdentifier, boolean updateRecordXml )
	    {
		 
		 IDX++ ;
		 
		 Element newPatientJournalEntry = DocumentHelper.createElement( elementName );
		 
         newPatientJournalEntry.addElement("mealType").addText("MealType");
         
         //<xsd:element name="timeOfMeal" type="basedatatypes:PointInTime" minOccurs="0"/> --> <xsd:complexType name="PointInTime">  
         newPatientJournalEntry.add(createPointInTime("timeOfMeal"));
         //newPatientJournalEntry.addElement("mealDescription").addText("MealDescription");
         
         //<xsd:element name="calories" type="basedatatypes:PhysicalQuantity" minOccurs="0"/> -->  <xsd:complexType name="PhysicalQuantity">
         if ( this.physicalQty != null )
         {
             newPatientJournalEntry.add( createPhysicalQuantity( "calories", this.physicalQty ) );
         }
         else
         {	 
         newPatientJournalEntry.add(createPhysicalQuantity("calories","Calories"));
         }
         //<xsd:element name="fat" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>---->  <xsd:complexType name="PhysicalQuantity">
         newPatientJournalEntry.add(createPhysicalQuantity("fat", "Fat"));
         //<xsd:element name="carbohydrates" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>---->  <xsd:complexType name="PhysicalQuantity">
         newPatientJournalEntry.add(createPhysicalQuantity("carbohydrates", "Carbohydrates"));
         //<xsd:element name="protein" type="basedatatypes:PhysicalQuantity" minOccurs="0"/>--->   <xsd:complexType name="PhysicalQuantity">
         //newPatientJournalEntry.add(createPhysicalQuantity("protien", "Protien"));
         if ( recordIdentifier != null )
         {
             newPatientJournalEntry.add( createGenericJournalEntryDetails/*RecordId*/( "genericJournalEntryDetails", patientIdentifier, IDX,
                             updateRecordXml, null, recordIdentifier, attachmentName  ) );
             
         }
         else{
         
         newPatientJournalEntry.add(createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml));
         }
         return newPatientJournalEntry;
		 
	    }
	 
	 
	 public Element makeDietPatientJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml )
	    {
	        Element patientJournalEntries = DocumentHelper.createElement( "patientJournalEntries" );
	        List<Element> patientJournalEntryList = makeJournalEntries( countObservations, patientIdentifier, updateRecordXml );
	        for ( Element patientJournalEntry : patientJournalEntryList )
	        {
	            patientJournalEntries.add( patientJournalEntry );
	        }

	        return patientJournalEntries;
	    }

	


	@Override
	public String fillPrintBuffer(Object object) {
		
		 String returnString = "";

	        if ( ( object != null ) && ( object instanceof Element ) )
	        {
	            returnString = ( ( Element )object ).asXML();
	        }

	        return returnString;

	}

}
