

package gov.va.med.cds.testharness.vhim400.builders;


import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class HAContactLogBuilder
    extends
        AbstractEntryPointBuilder
{
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";

    private String recordIdentifier;
    private String personContacted;
    private int IDX;
    private boolean createTwoAttachmentsWithSameName;

    public static final String[] CONTACT_METHODS = { "Method 1", "Method 2", "Method 3", "Method 4" };


    public HAContactLogBuilder( )
    {
        super();
    }


    public HAContactLogBuilder( String recordIdentifier, String personContacted )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.personContacted = personContacted;
    }

    public HAContactLogBuilder( String recordIdentifier, String personContacted, boolean createTwoAttachmentsWithSameName )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.personContacted = personContacted;
        this.createTwoAttachmentsWithSameName=createTwoAttachmentsWithSameName;
    }

    
    public HAContactLogBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAContactLogBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeJournalEntries( int number )
    {
        return makeJournalEntries( number, null );
    }


    public List<Element> makeJournalEntries( int number, Element patient )
    {
        return makeJournalEntries( number, patient, true );
    }


    public List<Element> makeJournalEntries( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makeJournalEntry( "patientjournaling:patientEnteredContactLogJournalEntry", patient, updateRecordXml ) );
        }

        return journalEntry;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makeJournalEntry( "patientjournaling:patientEnteredContactLogJournalEntry", personIdentifier );
    }


    public Element makeJournalEntry( String elementName, Element patientIdentifier )
    {
        return makeJournalEntry( elementName, patientIdentifier, false );
    }


    /*
     <xsd:complexType name="ContactLogEntry">
        <xsd:complexContent>
            <xsd:extension base="patientjournaling:PatientJournalEntry">
                <xsd:all>
                    <xsd:element name="contactMethod" type="basedatatypes:HL72CodedElementLite" minOccurs="0"/>
                    <xsd:element name="relatedTaskOrItem" type="xsd:string" minOccurs="0"/>
                    <xsd:element name="personContacted" type="xsd:string" minOccurs="0"/>
                    <xsd:element name="contactDateTime" type="basedatatypes:PointInTime" minOccurs="0"/>
                    <xsd:element name="genericJournalEntryDetails" type="patientjournaling:BasicJournalEntry"/>
                </xsd:all>
            </xsd:extension>
        </xsd:complexContent>
     </xsd:complexType>
     
     <xsd:complexType name="BasicJournalEntry">
        <xsd:all>
            <xsd:element name="patient" type="common:PatientLite"/>
            <xsd:element name="journalEntryType" type="xsd:anyType"/>
            <xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
            <xsd:element name="comments" type="xsd:string" minOccurs="0"/>
            <xsd:element name="observationDate" type="basedatatypes:PointInTime"/>
            <xsd:element name="dataEnterer" type="xsd:string" minOccurs="0"/>
        </xsd:all>
    </xsd:complexType>
     */
    public Element makeJournalEntry( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPatientJournalEntry = DocumentHelper.createElement( elementName );

        //Attribute contactLogEntryAttr = DocumentHelper.createAttribute( newPatientJournalEntry, "xsi:type", "patientjournaling:ContactLogEntry" );
        //newPatientJournalEntry.add( contactLogEntryAttr );

        Element newContactMethod = createHL72CodedElementLite( "contactMethod", "ContactMethod", CONTACT_METHODS );
        newPatientJournalEntry.add( newContactMethod );

        newPatientJournalEntry.addElement( "relatedTaskOrItem" ).addText( "RelatedTaskOrItem" );

        if ( personContacted != null )
            newPatientJournalEntry.addElement( "personContacted" ).addText( personContacted );
        else
            newPatientJournalEntry.addElement( "personContacted" ).addText( "PersonContacted" );

        Element newContactDateTime = createFixedPointInTime( "contactDateTime" );
        newPatientJournalEntry.add( newContactDateTime );

        if ( recordIdentifier != null )
            newPatientJournalEntry.add( createGenericJournalEntryDetailsRecordId( "genericJournalEntryDetails", patientIdentifier, IDX,
                            updateRecordXml, recordIdentifier ) );
        else
            newPatientJournalEntry.add( createGenericJournalEntryDetails( "genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml,createTwoAttachmentsWithSameName ) );

        return newPatientJournalEntry;
    }


    public Element makeContactLogPatientJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element patientJournalEntries = DocumentHelper.createElement( "patientJournalEntries" );
        List<Element> patientJournalEntryList = makeJournalEntries( countObservations, patientIdentifier, updateRecordXml );
        for ( Element patientJournalEntry : patientJournalEntryList )
        {
            patientJournalEntries.add( patientJournalEntry );
        }

        return patientJournalEntries;
    }


    public String fillPrintBuffer( Object object )
    {
        String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }
}
