

package gov.va.med.cds.testharness.vhim400.builders;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import static org.junit.Assert.*;

import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ClinicalDomainBuildersTest
    extends
        BuilderTest
{

    VitalsBuilder vitalsBuilder = new VitalsBuilder();
    LabBuilder labBuilder = new LabBuilder();
    IntoleranceConditionBuilder intoleranceConditionBuilder = new IntoleranceConditionBuilder();
    OutpatientMedicationPromiseBuilder outpatientMedicationPromiseBuilder = new OutpatientMedicationPromiseBuilder();
    AllergyAssessmentBuilder allergyAssessmentBuilder = new AllergyAssessmentBuilder();
    TiuBuilder tiuBuilder = new TiuBuilder();
    NonVaMedBuilder nonVaMedBuilder = new NonVaMedBuilder();


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateVitalsRecord( )
    {
        Element vitalsElement = vitalsBuilder.createEntryPointRecord( null );
        assertNotNull( vitalsElement );
        assertTrue( vitalsElement.hasContent() );
        printElementToSystemOut( vitalsElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateVitalsRecordWithPersonIdentifier( )
    {
        Element vitalsElement = vitalsBuilder.createEntryPointRecord( getPersonIdentifierElement( "test_vital_identity" ) );
        assertNotNull( vitalsElement );
        assertTrue( vitalsElement.hasContent() );
        printElementToSystemOut( vitalsElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    // test used only to generate example xml for dev testing
    public void testCreateLabRecord( )
    {
        Element labElement = labBuilder.createEntryPointRecord( null );
        assertNotNull( labElement );
        assertTrue( labElement.hasContent() );
        printElementToSystemOut( labElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateLabRecordWithPersonIdentifier( )
    {
        Element labElement = labBuilder.createEntryPointRecord( getPersonIdentifierElement( "test_lab_identity" ) );
        assertNotNull( labElement );
        assertTrue( labElement.hasContent() );
        printElementToSystemOut( labElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateIntoleranceConditionRecord( )
    {
        Element intoleranceConditionElement = intoleranceConditionBuilder.createEntryPointRecord( null );
        assertNotNull( intoleranceConditionElement );
        assertTrue( intoleranceConditionElement.hasContent() );
        printElementToSystemOut( intoleranceConditionElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateIntoleranceConditionRecordWithPersonIdentifier( )
    {
        Element intoleranceConditionElement = intoleranceConditionBuilder
                        .createEntryPointRecord( getPersonIdentifierElement( "test_intolerance_identity" ) );
        assertNotNull( intoleranceConditionElement );
        assertTrue( intoleranceConditionElement.hasContent() );

        printElementToSystemOut( intoleranceConditionElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseRecordWithPersonIdentifier( )
    {
        Element outpatientMedicationPromiseElement = outpatientMedicationPromiseBuilder
                        .createEntryPointRecord( getPersonIdentifierElement( "test_opmpr_identity" ) );
        assertNotNull( outpatientMedicationPromiseElement );
        assertTrue( outpatientMedicationPromiseElement.hasContent() );

        printElementToSystemOut( outpatientMedicationPromiseElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseRecord( )
    {
        Element outpatientMedicationPromiseElement = outpatientMedicationPromiseBuilder.createEntryPointRecord( null );
        assertNotNull( outpatientMedicationPromiseElement );
        assertTrue( outpatientMedicationPromiseElement.hasContent() );

        printElementToSystemOut( outpatientMedicationPromiseElement );
    }


    private Element getPersonIdentifierElement( String identity )
    {
        return BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", identity );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testAllergyAssesmentBuilder( )
        throws Exception
    {
        Element allergyAssessmentElement = allergyAssessmentBuilder.createEntryPointRecord( null );
        assertNotNull( allergyAssessmentElement );
        assertTrue( allergyAssessmentElement.hasContent() );

        printElementToSystemOut( allergyAssessmentElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testAllergyAssesmentBuilderWithPersonIdentifier( )
        throws Exception
    {
        Element allergyAssessmentElement = allergyAssessmentBuilder
                        .createEntryPointRecord( getPersonIdentifierElement( "test_allergy_assessment_identity" ) );
        assertNotNull( allergyAssessmentElement );
        assertTrue( allergyAssessmentElement.hasContent() );

        printElementToSystemOut( allergyAssessmentElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testTiuBuilder( )
        throws Exception
    {
        Element clinicalDocumentEventElement = tiuBuilder.createEntryPointRecord( null );

        assertNotNull( clinicalDocumentEventElement );
        assertTrue( clinicalDocumentEventElement.hasContent() );

        printElementToSystemOut( clinicalDocumentEventElement );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testTiuBuilderWithPersonIdentifier( )
        throws Exception
    {
        Element clinicalDocumentEventElement = tiuBuilder
                        .createEntryPointRecord( getPersonIdentifierElement( "test_clinicalDocumentEvent_identity" ) );

        assertNotNull( clinicalDocumentEventElement );
        assertTrue( clinicalDocumentEventElement.hasContent() );

        printElementToSystemOut( clinicalDocumentEventElement );
    }
    
    
    @Test
    @Suite( groups = "prototypetest" )
    public void testNonVaMedBuilder( )
        throws Exception
    {
        Element nonVAMedicationElement = nonVaMedBuilder.createEntryPointRecord( null );

        assertNotNull( nonVAMedicationElement );
        assertTrue( nonVAMedicationElement.hasContent() );

        printElementToSystemOut( nonVAMedicationElement );
    }
    
    
    @Test
    @Suite( groups = "prototypetest" )
    public void testNonVaMedBuilderWithPersonIdentifier( )
        throws Exception
    {
        Element nonVAMedicationElement = nonVaMedBuilder
                        .createEntryPointRecord( getPersonIdentifierElement( "test_nonVaMedicationEvent_identity" ) );

        assertNotNull( nonVAMedicationElement );
        assertTrue( nonVAMedicationElement.hasContent() );

        printElementToSystemOut( nonVAMedicationElement );
    }
}
