

package gov.va.med.cds.testharness.examples.spring;


import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.testharness.AbstractInjectedTransactionDataSourceTest;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;


/**
 * Unit tests demonstrating how to use transaction based unit tests
 */
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/testharness/examples/spring/transactionalSpringContextTest-context.xml" } )
@TransactionConfiguration( transactionManager = "transactionManager", defaultRollback = false )
@Transactional
@RunWith( SuiteAwareSpringRunner.class )
public class TransactionalSpringContextTest
    extends
        AbstractInjectedTransactionDataSourceTest
{

   private final String tableName = "CDS_AUDIT_LOG3";


    @Test
    @Suite( groups = "prototypetest" )
    public void testSetUp( )
    {
        Assert.assertNotNull( jdbcTemplate );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCountRowsInTable( )
    {
        logger.debug( "COUNTING BEFORE SCRIPT :" + countRowsInTable( tableName ) );
        logger.debug( "datasource/template: " + jdbcTemplate );
        String sqlResourcePath = "classpath:gov/va/med/cds/testharness/examples/spring/test.sql";
        executeSqlScript( sqlResourcePath, false );
        logger.debug( "COUNTING AFTER SCRIPT :" + countRowsInTable( tableName ) );
    }
}
