

package gov.va.med.cds.testharness.examples;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;


/**
 * Unit tests demonstrating how to use JaxP Xpath.
 */
@RunWith( SuiteAwareRunner.class )
public class SimpleJaxpXpathEvaluateTest
{
    /**
     * Unit test demonstrating how to use xpath evaluation
     *
     * @throws XPathExpressionException
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testXPathEvaluate( )
        throws XPathExpressionException
    {
        final String inputXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><doc><name>expectedName</name></doc>";
        javax.xml.xpath.XPathFactory factory = javax.xml.xpath.XPathFactory.newInstance();
        javax.xml.xpath.XPath xpath = factory.newXPath();

        javax.xml.xpath.XPathExpression expression = xpath.compile( "/doc/name" );

        String result = expression.evaluate( new org.xml.sax.InputSource( new StringReader( inputXml ) ) );
        Assert.assertEquals( result, "expectedName" );
        Assert.assertNotSame( result, "notTheRightValue" );
    }

    Map<String, String> namespaceResolver = new HashMap<String, String>();


    /**
     * Test demonstrating xpath evaluation with a more complex VHIM Template like xml
     *
     * @throws Exception
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testXPathEvaluateTemplateLikeXml( )
        throws Exception
    {
        final String inputXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
                        + "<template3400:ClinicalData xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:allergies3400=\"Allergies3400\" xmlns:common3400=\"Common3400\" xmlns:template3400=\"Template3400\" errorSection=\"NONE\" templateId=\"CustomStrictAllergiesFullInsertTemplate\" vhimVersion=\"VHIM3400\">"
                        + "<allergies3400:intoleranceCondition>" + "someValue" + "</allergies3400:intoleranceCondition>"
                        + "</template3400:ClinicalData>";

        namespaceResolver.put( "allergies3400", "Allergies3400" );
        namespaceResolver.put( "common3400", "Common3400" );
        namespaceResolver.put( "template3400", "Template3400" );

        javax.xml.xpath.XPathFactory factory = javax.xml.xpath.XPathFactory.newInstance();
        javax.xml.xpath.XPath xpath = factory.newXPath();
        xpath.setNamespaceContext( new NamespaceContext()
        {

            public String getNamespaceURI( String arg0 )
            {
                return namespaceResolver.get( arg0 );
            }


            public String getPrefix( String arg0 )
            {
                return "";
            }


            public Iterator<Object> getPrefixes( String arg0 )
            {
                return null;
            }

        } );

        javax.xml.xpath.XPathExpression expression = xpath.compile( "/template3400:ClinicalData/allergies3400:intoleranceCondition" );

        String result = expression.evaluate( new org.xml.sax.InputSource( new StringReader( inputXml ) ) );
        Assert.assertEquals( result, "someValue" );
        Assert.assertNotSame( result, "notTheRightValue" );
    }
}
