

package gov.va.med.cds.testharness.examples;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * Unit test example of how to set up an expected failure
 */
@RunWith( SuiteAwareRunner.class )
public class ExpectedFailureExampleTest
{

    /**
     * Test demonstrating expected exception
     *
     */
    @Test( expected = ExampleException.class )
    @Suite( groups = "checkintest" )
    public void expectExceptionTest( )
    {
        ExampleExceptionThrower tester = new ExampleExceptionThrower();
        tester.doIt();
    }

    public class ExampleExceptionThrower
    {
        public void doIt( )
        {
            throw new ExampleException();
        }
    }

    public class ExampleException
        extends
            RuntimeException
    {
        public ExampleException( )
        {
            super();
        }


        public ExampleException( String message, Throwable cause )
        {
            super( message, cause );
        }


        public ExampleException( String message )
        {
            super( message );
        }


        public ExampleException( Throwable cause )
        {
            super( cause );
        }

        private static final long serialVersionUID = 1L;

    }
}
