

package gov.va.med.cds.testharness;


import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * This abstract class should be used as a base for all tests that don't use spring inject. By using this as a base the
 * logging and property configuration is setup automatically to support multiple sand boxes.
 */
public abstract class AbstractLoggingTest
{
    protected static Log logger = null;
    private static String logfilePath = null;
    private static LoggingAndPropertyConfigurator configurator = null;
    private static final String APPLICATION_NAME = "CDS";


    protected AbstractLoggingTest( String logfilePath )
    {
        this();
        AbstractLoggingTest.logfilePath = logfilePath;
    }


    protected AbstractLoggingTest( )
    {
        logger = LogFactory.getLog( getClass() );
    }


    @SuppressWarnings( "static-access" )
    @BeforeTestsOnce
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractLoggingTestClassSetUp( )
        throws Exception
    {
        logger = LogFactory.getLog( AbstractLoggingTest.class );
        //configurator = new LoggingAndPropertyConfigurator();
        //configurator.configureLoggingAndProperties( logger, logfilePath );
        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME,
                            "just finished beforeAbstractLoggingTestClassSetUp" ) );
    }


    @AfterTestsOnce
    @Suite( groups = { "checkintest" } )
    public void afterAbstractLoggingJUnitTestClassTearDown( )
        throws Exception
    {
        configurator = null;
        logfilePath = null;
        logger = null;
    }

}
