

package gov.va.med.cds.testharness;


import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;


/**
 * Runs a test in a Spring auto generated transaction context and rolls back the transaction once the test is completed.
 * 
 * By using this as a base the logging and property configuration is setup automatically to support multiple sand boxes.
 */
public abstract class AbstractInjectedTransactionDataSourceTest
    extends
        AbstractTransactionalJUnit4SpringContextTests
{ 
	protected static Log logger = null;
    private static String logfilePath = null;
    private static LoggingAndPropertyConfigurator configurator = null;
    private static final String APPLICATION_NAME = "CDS";


    protected AbstractInjectedTransactionDataSourceTest( String logfilePath )
    {
        this();
        AbstractInjectedTransactionDataSourceTest.logfilePath = logfilePath;
    }


    protected AbstractInjectedTransactionDataSourceTest( )
    {
        logger = LogFactory.getLog( getClass() );
    }


    @Override
   @Resource
   public void setDataSource( DataSource dataSource )
    {
        super.setDataSource( dataSource );
    }


   @BeforeClass
    public static void beforeAbstractInjectedTransactionDataSourceTestSetup( )
        throws Exception
    {

        logger = LogFactory.getLog( Object.class );
        //LoggingAndPropertyConfigurator.configureLoggingAndProperties( logger, logfilePath );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME,
                            "just finished springTestContextPrepareTestInstance " ) );
        }
    }


   @AfterClass
    public static void afterClassTearDown( )
        throws Exception
    {
    	AbstractInjectedTransactionDataSourceTest.logfilePath = null;
    	AbstractInjectedTransactionDataSourceTest.configurator = null;
    }
}
