

package gov.va.med.cds.testharness;


import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlComparatorInterface;
import gov.va.med.cds.testharness.xml.XmlCompareException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;


/**
 * This abstract class should be used for all spring injected tests, except for
 * those tests which need automatic transaction control with data sources By
 * using this as a base the logging and property configuration is setup
 * automatically to support multiple sand boxes.
 */

public abstract class AbstractBaseTest
    implements
        XmlComparatorInterface
{

    protected static Log logger = null;
    protected static String logfilePath = null;
    protected static XmlComparator xmlComparator = null;
    protected static LoggingAndPropertyConfigurator configurator = null;
    private static final String APPLICATION_NAME = "CDS";
    protected static String uniquePatientIdentity = null;


    /*-- this Variable is the flag to ensure that the initialization code in @Before is executed only once during a test execution--*/

    protected AbstractBaseTest( String logPath )
    {
        this();
        logfilePath = logPath;
    }


    protected AbstractBaseTest( )
    {
        super();
    }


    public void assertXMLSimilar( String control, String test )
        throws XmlCompareException
    {
        xmlComparator.assertXMLSimilar( test, control );
    }


    @BeforeClass
    public static void beforeAbstractInjectionJUnitTestClassSetUp( )
        throws Exception
    {
        logger = LogFactory.getLog( AbstractBaseTest.class );
        xmlComparator = new XmlComparator();
        //configurator = new LoggingAndPropertyConfigurator();
        //LoggingAndPropertyConfigurator.configureLoggingAndProperties( logger, logfilePath );
        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "just finished junit4SetUp" ) );
        }
    }


    @AfterClass
    public static void afterAbstractInjectionJUnitTestTearDown( )
        throws Exception
    {
        logfilePath = null;
        xmlComparator = null;
        configurator = null;
        logfilePath = null;
    }


    // Methods to overwrite fields in the class and set them to mocks.
    public void setLogfilePath( String logfilePath )
    {
        AbstractBaseTest.logfilePath = logfilePath;
    }


    public void setXmlComparator( XmlComparator xmlComparator )
    {
        AbstractBaseTest.xmlComparator = xmlComparator;
    }


    public void setConfigurator( LoggingAndPropertyConfigurator configurator )
    {
        AbstractBaseTest.configurator = configurator;
    }


    public void setLogger( Log logger )
    {
        AbstractBaseTest.logger = logger;
    }


    public static void setUniquePatientIdentity( String uniquePatientIdentity )
    {
        AbstractBaseTest.uniquePatientIdentity = uniquePatientIdentity;
    }

}
