

package gov.va.med.tfs.tfdm;


import java.util.HashSet;
import java.util.Set;


public interface TemplateMetaDataInterface 
	
{

    /**
     * @return the domainEntryPoint
     */
    Set<DomainEntryPoint> getDomainEntryPoints( );


    /**
     * @param theDomainEntryPoint the domainEntryPoint to set
     */
    void setDomainEntryPoints( Set<DomainEntryPoint> theDomainEntryPoint );


    /**
     * @return the vhimVersion
     */
    String getWriteCdsVdm( );


    /**
     * @param aCdsVdm the cds vdm to set
     */
    void setWriteCdsVdm( String aCdsVdm );


    /**
     * @return the vhimVersion
     */
    HashSet<String> getReadCdsVdms( );


    /**
     * @param aCdsVdms the cds vdm hashset to set
     */
    void setReadCdsVdms( HashSet<String> aCdsVdms );


    /**
     * @return the array of valid vhimVersions
     */
    Set<String> getVhimVersions( );


    /**
     * @param aVhimVersions the array of valid vhimVersion to set
     */
    void setVhimVersions( Set<String> aVhimVersions );


    Set<VhimVersionWrapper> getVhimVersionWrappers( );
    
    
    void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersions );
    
    
    /**
     * @return the templateId
     */
    String getTemplateId( );


    /**
     * @param theTemplateId the templateId to set
     */
    void setTemplateId( String theTemplateId );


    /**
     * @return the templateName
     */
    String getTemplateName( );


    /**
     * @param theTemplateName the templateName to set
     */
    void setTemplateName( String theTemplateName );


    /**
     * @return the templateDescription
     */
    String getTemplateDescription( );


    /**
     * @param theTemplateDescription the templateDescription to set
     */
    void setTemplateDescription( String theTemplateDescription );


    /**
     * @return the operation
     */
    String getOperation( );


    /**
     * @param theOperation the operation to set
     */
    void setOperation( String theOperation );


    void setTestOnly( boolean theTestOnly );


    void setTestOnly( String aTrueOrFalse );


    boolean getTestOnly( );
}
