

package gov.va.med.tfs.tfdm;


import java.util.Set;

import javax.xml.validation.Schema;


/**
 * This interface defines the methods required for handling the Filter Cache Metadata. The Metadata consists of:
 * <li>FilterId
 * <li>Filter Schema (XSD)
 * <li>Validator
 * <li>VHIM Version
 * <li>Domain Entry Points <br>
 * 
 */
public interface FilterMetaDataInterface
{
    String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";


    /**
     * Get the filterId.
     * 
     * @return the filterId
     */
    String getFilterId( );


    /**
     * Set the filterId.
     * 
     * @param theFilterId the filterId to set
     */
    void setFilterId( String theFilterId );


    /**
     * Get the Filter Schema as String which is the XML schema (XSD).
     * 
     * @return the filterString
     */
    String getFilterString( );


    /**
     * Set the Filter String.
     * 
     * @param theFilterString the filter Schema as String to set
     */
    void setFilterString( String theFilterString );


    /**
     * Get the filterSchema which is the XML schema (XSD).
     * 
     * @return the filterSchema
     */
    Schema getFilterSchema( );


    /**
     * Set the Filter Schema using the passed in schema.
     * 
     * @param aFilterSchema the schema
     */
    void setFilterSchema( Schema aFilterSchema );
    
    
    /**
     * Set the Filter Schema.
     * 
     * @param theFilterSchemaString to create the filterSchema to set
     */
    void setFilterSchema( String theFilterSchema );


    /**
     * Get the VHIM version.
     * 
     * @return the array of valid vhimVersion
     */
    Set<String> getVhimVersions( );


    /**
     * Set the VHIM version.
     * 
     * @param aVhimVersion the valid vhimVersion to set
     */
    void setVhimVersions( Set<String> theVhimVersion );
    
    
    Set<VhimVersionWrapper> getVhimVersionWrappers( );
    
    void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersions );


    Set<EntryFilter> getEntryFilters( );


    void setEntryFilters( Set<EntryFilter> theEntryFilters );
}
