package gov.va.med.tfs.persistence.hibernate;

import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.tfs.tfdm.DomainEntryPoint;
import gov.va.med.tfs.tfdm.VhimVersionWrapper;
import gov.va.med.tfs.persistence.hibernate.AbstractHibernatePersistenceManager;

public class AbstractTfsHibernatePersistenceManager
    extends
        AbstractHibernatePersistenceManager
{

    protected void persistifyVhimVersions( Session aSession, Set<VhimVersionWrapper> vhimVersions )
    {
        VhimVersionWrapper[] vhimVersionsArray = vhimVersions.toArray( new VhimVersionWrapper[]{} );
    
        VhimVersionWrapper queryResult = null;
        
        
        // for each of the vhim version objects in the templatemetadata, check to see if that version already exists in the database
        // if it does, replace the one in the TMD collection with the persistent version.
        for ( VhimVersionWrapper vhimVersionWrapper : vhimVersionsArray )
        {
            Query query = aSession.getNamedQuery( "VhimVersionText" ).setParameter( "vhimVersionTxt", vhimVersionWrapper.getVersion() );
            queryResult = (VhimVersionWrapper)query.uniqueResult();
            
            if ( queryResult != null )
            {
                vhimVersions.remove( vhimVersionWrapper );
                vhimVersions.add( queryResult );
            }
            // if vhim version doesn't exist, cascade on TMD will do it 
        }
    }

    
    protected void persistifyDomainEntryPoints( Session aSession, Set<DomainEntryPoint> domainEntryPoints )
    {
        DomainEntryPoint[] domainEntryPointsArray = domainEntryPoints.toArray( new DomainEntryPoint[]{} );
    
        DomainEntryPoint queryResult = null;
        
        
        // for each of the entry point objects in the templatemetadata, check to see if that entrypoint already exists in the database
        // if it does, replace the one in the TMD collection with the persistent version.
        for ( DomainEntryPoint domainEntryPoint : domainEntryPointsArray )
        {
            Query query = aSession.getNamedQuery( "DomainEntryPointText" ).setParameter( "nameTxt", domainEntryPoint.getName() ).setParameter( "domainTxt", domainEntryPoint.getDomain() );
            queryResult = (DomainEntryPoint)query.uniqueResult();

            if ( queryResult != null )
            {
                domainEntryPoints.remove( domainEntryPoint );
                domainEntryPoints.add( queryResult );
            }
            // if entry point doesn't exist, cascade on TMD will do it 
        }
    }

    /**
     * Persists a DEP if not already persisted.
     * @param aSession
     * @param aDomainEntryPoint
     * @return the persisted version of the DEP.
     */
    protected DomainEntryPoint persistifyDomainEntryPoint( Session aSession, DomainEntryPoint aDomainEntryPoint )
    {
        DomainEntryPoint queryResult = null;
        
        Query query = aSession.getNamedQuery( "DomainEntryPointText" ).setParameter( "nameTxt", aDomainEntryPoint.getName() ).setParameter( "domainTxt", aDomainEntryPoint.getDomain() );
        queryResult = (DomainEntryPoint)query.uniqueResult();
            
        if ( queryResult == null ) // not persisted
        {
            aSession.save( aDomainEntryPoint );
            queryResult = aDomainEntryPoint;
        }
            
        return queryResult;
    }
}
