# Load properties from file
from java import util
from java import io
from java import lang

props = util.Properties();
#java.lang.System.getenv("CDSN_HOME") + 
filepath= java.lang.System.getenv("CDSN_HOME") + "/environments/properties/" + sys.argv[1]
fis = io.FileInputStream(io.File( filepath));
props.load(fis);

deployServer = props.getProperty("cds.appserver.target.server")

jmsServer = ["CLINICAL",deployServer,
             "LOGGER",deployServer]

# Name of persistent store, prefix, target server
jdbcStore = ["ClinicalPersistentStore","CLINICAL",deployServer,
             "LoggerPersistentStore","LOGGER",deployServer]

jmsModule = ["ClinicalModule","CLINICAL",
             "LoggerModule","LOGGER"]

jmsSubdeployment = ["ClinicalSubdeployment","ClinicalModule","CLINICAL",
                    "LoggerSubdeployment","LoggerModule","LOGGER"]

jmsQueue = ["ErrorQueue","ClinicalSubdeployment", "ClinicalModule","noError",
            "LoggerQueue","LoggerSubdeployment", "LoggerModule","noError",
			"ReadAuditQueue","LoggerSubdeployment", "LoggerModule","noError",
            "AllergiesQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "AdtQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "DoDPatientCorrelationQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "VaPatientCorrelationQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "AllergyAssessmentQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "PharmacyRefillQueue","ClinicalSubdeployment","ClinicalModule","Error",
            "PharmacyFullQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"PharmacyPartialQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"LabQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"VitalsQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"ChdrQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"HomeTeleHealthQueue","ClinicalSubdeployment","ClinicalModule","Error",
			"DefaultQueue","ClinicalSubdeployment","ClinicalModule","Error"]

jmsConnectionfactory = ["CDSClinicalJMSConnectionFactory","jms/cds/CDSClinicalJMSConnectionFactory","ClinicalSubdeployment","ClinicalModule",
                        "LoggerConnectionFactory","jms/cds/LoggerConnectionFactory","LoggerSubdeployment", "LoggerModule"]


