#==========================================================================
# open the domain.
#==========================================================================

readDomain(props.getProperty("cds.appserver.domaindir"))

#==========================================================================
# Create a JMS JDBC Store function.
#==========================================================================

def createJDBCstore(JdbcStoreName,PrefixName,dataSource,deployServer):
   cd('/')
   myJDBCStore=create(JdbcStoreName,'JdbcStore')
   cd("/JDBCStores/"+JdbcStoreName)
   set("PrefixName", PrefixName)
   # Use oracle ddl to create a JDBC store table with a BLOB record column type rather than the default LONG RAW
   set('CreateTableDDLFile','/weblogic/store/io/jdbc/ddl/oracle_blob.ddl' )   
   myJDBCStore.setDataSource(dataSource)
   cd('/')
   assign('JdbcStore',JdbcStoreName,'Server',deployServer)
   print 'Created JDBC Store ' + JdbcStoreName + ' on ' +deployServer
   return myJDBCStore   
#==========================================================================
# Create and assign JMS Server function. 
#==========================================================================

 
def   createJMSserver(ServerName,TargetName,myJDBCStore):
   cd('/')
   myJMSServer = create(ServerName, 'JMSServer')
   assign('JMSServer', ServerName, 'Target', TargetName)
   myJMSServer.setPersistentStore(myJDBCStore)
   print ServerName + " JMS Server created " 

#==========================================================================
# Create and assign  JMS System resource and subdeployment function 
#==========================================================================

def createJMSResourceAndDeployment(SubdeploymentName,ModuleName,TargetName,deployServer):  
   print 'createJMSResourceAndDeployment('+SubdeploymentName+','+ModuleName+','+TargetName+','+deployServer+')'
   cd('/')
   create(ModuleName, 'JMSSystemResource')
   cd('JMSSystemResource/'+ModuleName)
   create(SubdeploymentName, 'SubDeployment')
   cd('/')
   modulestring=ModuleName +"."+SubdeploymentName
   assign('JMSSystemResource',ModuleName, 'Target', deployServer)
   assign('JMSSystemResource.SubDeployment',modulestring, 'Target', TargetName)
#
#==========================================================================
# Create  JMS Queue function
#==========================================================================
def createJMSQueue(QueueName,SubdeploymentName,ModuleName,needErrorQueue,ErrorQueue):  
   cd('/')
   cd('JMSSystemResource/'+ModuleName+'/JmsResource/NO_NAME_0')
   myq=create(QueueName,'Queue')
   cd('Queues/'+QueueName)
   QueueJNDIName="jms/cds/"+QueueName
   set('JNDIName',QueueJNDIName)
   myq.setSubDeploymentName(SubdeploymentName)
   if(needErrorQueue != "noError"):
      DeliveryFailureParams=create('DeliveryFailureParams','DeliveryFailureParams')
      DeliveryFailureParams.setExpirationPolicy('Redirect')
      DeliveryFailureParams.setRedeliveryLimit(4)
      DeliveryFailureParams.setErrorDestination(ErrorQueue)
   return myq
#==========================================================================
# Create  JMS  connection factory  function
#==========================================================================
def createJMSConnectionFactory(ConnectionfactoryName,JNDIName,SubdeploymentName,ModuleName):  
   cd('/')
   cd('JMSSystemResource/'+ModuleName+'/JmsResource/NO_NAME_0')
   myq=create(ConnectionfactoryName,'ConnectionFactory')
   cd('ConnectionFactories/'+ConnectionfactoryName)
   set('JNDIName',JNDIName)
   myq.setSubDeploymentName(SubdeploymentName)
   TransParams=create('TransactionParams','TransactionParams')
   TransParams.setXAConnectionFactoryEnabled(true)
#==========================================================================
#          Main  creation starts here
#==========================================================================

print '					Creating JDBC Store and JMS Servers '

#========================================================================================================================================
# JMS Servers' PersistentStore Data Source
#========================================================================================================================================
url=createURL("weblogicDriver", props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
clinicalStoreDataSource = createPhysicalDataSource( "ClinicalStoreDataSource",
                          "jdbc/ClinicalStoreDataSource",
   					      "",
   						  "NonXADriver",
						  url,
                          props.getProperty("cds.oracle.schema.wlqueue.username"),
   						  props.getProperty("cds.oracle.schema.wlqueue.password"),
   						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "ClinicalStoreDataSource", props.getProperty("cds.oracle.schema.wlqueue.username"), props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
setJDBCConnectionPoolParameter("ClinicalStoreDataSource", "1", "15", "1")

url=createURL("weblogicDriver", props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
loggerStoreDataSource = createPhysicalDataSource( "LoggerStoreDataSource",
                          "jdbc/LoggerStoreDataSource",
   					      "",
   						  "NonXADriver",
						  url,
                          props.getProperty("cds.oracle.schema.wlqueue.username"),
   						  props.getProperty("cds.oracle.schema.wlqueue.password"),
   						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "LoggerStoreDataSource", props.getProperty("cds.oracle.schema.wlqueue.username"), props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
setJDBCConnectionPoolParameter("LoggerStoreDataSource", "1", "15", "1")

for i in range(len(jmsServer)/2):
     if(i == 0):
         cdsJdbcStore = createJDBCstore(jdbcStore[3*i],jdbcStore[(3*i)+1],clinicalStoreDataSource,jdbcStore[(3*i)+2])
     else:
         cdsJdbcStore = createJDBCstore(jdbcStore[3*i],jdbcStore[(3*i)+1],loggerStoreDataSource,jdbcStore[(3*i)+2])
     createJMSserver(jmsServer[2*i], jmsServer[(2*i)+1], cdsJdbcStore)
     updateDomain()
print '\n'+'...............Creating SubDeployment and Module.............................'

for i in range(len(jmsSubdeployment)/3):
   createJMSResourceAndDeployment(jmsSubdeployment[3*i],jmsSubdeployment[(3*i) + 1],jmsSubdeployment[(3*i) + 2], props.getProperty("cds.appserver.target.server"))  
   print ' created  ' + jmsSubdeployment[3*i]  + ' and ' + jmsSubdeployment[(3*i) + 1] + ' on '+ jmsSubdeployment[(3*i) + 2]

#==========================================================================
# Write the domain and close the domain template and exit WLST
#==========================================================================
updateDomain()
closeDomain()
#==========================================================================
# open the domain.
#==========================================================================

readDomain(props.getProperty("cds.appserver.domaindir"))

   
print '\n'+'...............Creating JMS Queue...........................................'

for i in range(len(jmsQueue)/4):
   jmsQueue[(4*i)+3]=createJMSQueue(jmsQueue[4*i],jmsQueue[(4*i)+1],jmsQueue[(4*i)+2],jmsQueue[(4*i)+3],jmsQueue[3])
   print ' created ' +  jmsQueue[4*i] + ' on ' + jmsQueue[(4*i)+1] + '.' + jmsQueue[(4*i)+2] 

print '\n'+'................Creating JMS Connection Factory..............................'

for i in range(len(jmsConnectionfactory)/4):
    createJMSConnectionFactory(jmsConnectionfactory[4*i],jmsConnectionfactory[(4*i)+1],jmsConnectionfactory[(4*i)+2],jmsConnectionfactory[(4*i)+3])
    print ' created ' + jmsConnectionfactory[4*i] + ' on ' + jmsConnectionfactory[(4*i) +2] + '.' + jmsConnectionfactory[(4*i)+3]
   
#==========================================================================
# Write the domain and close the domain template and exit WLST
#==========================================================================
updateDomain()
closeDomain()
