

package gov.va.med.tfs.junit.runners;


import java.lang.reflect.Method;
import java.util.List;

import org.junit.internal.runners.InitializationError;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sorter;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;


public class SuiteAwareSpringRunner
    extends
        SpringJUnit4ClassRunner
{
    private boolean keepExecution = true;

    @SuppressWarnings("deprecation")
	public SuiteAwareSpringRunner( Class<?> klass )
        throws InitializationError, Exception
    {
        super( klass );
        filter( new GroupAwareFilter() );
        sort( new Sorter( new DependancyComparator() ) );
    }


/*    @Override
    protected List<Method> getTestMethods( )
    {
        List<Method> methods = super.getTestMethods();
        methods.addAll( RunnerUtils.getCustomaAnotatedMethods( getTestClass() ) );
        return methods;
    }*/


    @Override
    public void filter( Filter filter )

    {
        try
        {
            super.filter( filter );
        }
        catch ( NoTestsRemainException e )
        {
            keepExecution = false;

        }
    }


    @Override
    public void sort( Sorter sorter )
    {
        if ( !keepExecution )
            return;
        super.sort( sorter );
    }
}