

package gov.va.med.tfs.junit.runners;


import java.util.List;

import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sorter;
import java.lang.reflect.Method;


public class SuiteAwareRunner
    extends
        JUnit4ClassRunner
{
    private boolean keepExecution = true;


    public SuiteAwareRunner( Class<?> klass )
        throws InitializationError,
            NoTestsRemainException
    {
        super( klass );
        filter( new GroupAwareFilter() );
        sort( new Sorter( new DependancyComparator() ) );
    }


    @Override
    protected List<Method> getTestMethods( )
    {
        List<Method> methods = super.getTestMethods();
        methods.addAll( RunnerUtils.getCustomaAnotatedMethods( getTestClass() ) );
        return methods;
    }


    @Override
    public void filter( Filter filter )

    {
        try
        {
            super.filter( filter );
        }
        catch ( NoTestsRemainException e )
        {
            keepExecution = false;

        }
    }


    @Override
    public void sort( Sorter sorter )
    {
        if ( !keepExecution )
            return;
        super.sort( sorter );
    }
}
