

package gov.va.med.tfs.mapping.tfstocds;


import gov.va.med.tfs.client.webservice.EntryFilter;
import gov.va.med.tfs.client.webservice.FilterMetaData;
import gov.va.med.tfs.mapping.MapperInterface;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.datatype.XMLGregorianCalendar;


public class FilterMetaDataMapper
    implements
        MapperInterface<FilterMetaData, gov.va.med.cds.clinicaldata.FilterMetaData>
{
    private static FilterMetaDataMapper templateMetaDataMapper = new FilterMetaDataMapper();


    private FilterMetaDataMapper( )
    {
    }


    public static FilterMetaDataMapper getInstance( )
    {
        return templateMetaDataMapper;
    }


    @Override
    public gov.va.med.cds.clinicaldata.FilterMetaData map( FilterMetaData fromTfsFilterMetaData )
        throws Exception
    {
        gov.va.med.cds.clinicaldata.FilterMetaData toCdsFilterMetaData = new gov.va.med.cds.clinicaldata.FilterMetaData();

        String fromTfsFilterId = fromTfsFilterMetaData.getFilterId();
        if ( fromTfsFilterId != null )
        {
            toCdsFilterMetaData.setFilterId( fromTfsFilterId );
        }

        //same content as FilterSchemaXml
        /*        String fromTfsFilterString = fromTfsFilterMetaData.getFilterString();
                if ( fromTfsFilterString != null )
                {
                	toCdsFilterMetaData.setFilterString( fromTfsFilterString );
                }*/

        List<EntryFilter> fromEntryFilters = fromTfsFilterMetaData.getEntryFilters();

        if ( fromEntryFilters != null )
        {
            Set<gov.va.med.cds.clinicaldata.EntryFilter> toEntryFilters = new HashSet<gov.va.med.cds.clinicaldata.EntryFilter>();
            for ( EntryFilter fromEntryFilter : fromEntryFilters )
            {
                if ( fromEntryFilter != null )
                {
                    toEntryFilters.add( EntryFilterMapper.getInstance().map( fromEntryFilter ) );
                }
            }
            toCdsFilterMetaData.setEntryFilters( toEntryFilters );
        }

        List<String> fromTfsVhimVersions = fromTfsFilterMetaData.getVhimVersions();

        if ( fromTfsVhimVersions != null )
        {
            Set<String> toCdsVhimVersions = new HashSet<String>();

            for ( String fromTfsVhimVersion : fromTfsVhimVersions )
            {
                toCdsVhimVersions.add( fromTfsVhimVersion );
            }
            toCdsFilterMetaData.setVhimVersions( toCdsVhimVersions );
        }

        //???????
        String fromTfsTemplateJar = fromTfsFilterMetaData.getFilterSchemaXml();
        if ( fromTfsTemplateJar != null )
        {
            /*        	StringReader fromTfsTemplateJarStringReader = new StringReader( fromTfsTemplateJar );
                    	File f = null;
                    	StreamSource fromTfsTemplateJarStreamSource = new StreamSource( f );
                    	SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
                    	Schema s = sf.newSchema( fromTfsTemplateJarStreamSource );*/

            toCdsFilterMetaData.setFilterSchema( fromTfsTemplateJar );
        }

        String fromTfsFilterDescription = fromTfsFilterMetaData.getFilterDescription();
        if ( fromTfsFilterDescription != null )
        {
            toCdsFilterMetaData.setFilterDescription( fromTfsFilterDescription );
        }

        boolean fromTfsContainsCorrelation = fromTfsFilterMetaData.isContainsCorrelation();
        toCdsFilterMetaData.setContainsCorrelation( fromTfsContainsCorrelation );

        XMLGregorianCalendar fromTfsDateAdded = fromTfsFilterMetaData.getDateAdded();

        if ( fromTfsDateAdded != null )
        {
            toCdsFilterMetaData.setDateAdded( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateDeprecated = fromTfsFilterMetaData.getDateDeprecated();
        if ( fromTfsDateDeprecated != null )
        {
            toCdsFilterMetaData.setDateDeprecated( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateActivated = fromTfsFilterMetaData.getDateActivated();
        if ( fromTfsDateActivated != null )
        {
            toCdsFilterMetaData.setDateActivated( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateDeactivated = fromTfsFilterMetaData.getDateDeactivated();
        if ( fromTfsDateDeactivated != null )
        {
            toCdsFilterMetaData.setDateDeactivated( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateUpdated = fromTfsFilterMetaData.getDateUpdated();
        if ( fromTfsDateUpdated != null )
        {
            toCdsFilterMetaData.setDateUpdated( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        String fromTfsStatus = fromTfsFilterMetaData.getStatus();
        if ( fromTfsStatus != null )
        {
            toCdsFilterMetaData.setStatus( fromTfsStatus );
        }

        String fromTfsFilterSchemaXml = fromTfsFilterMetaData.getFilterSchemaXml();
        if ( fromTfsFilterSchemaXml != null )
        {
            toCdsFilterMetaData.setFilterSchemaXml( fromTfsFilterSchemaXml );
        }

        /*        List<DomainEntryPoint> fromTfsDomainEntryPoints = fromTfsFilterMetaData.get..getDomainEntryPoints();
                if ( fromTfsDomainEntryPoints != null )
                {
                	Set<gov.va.med.tfs.clinicaldata.DomainEntryPoint> toCdsDomainEntryPoints = new HashSet<gov.va.med.tfs.clinicaldata.DomainEntryPoint>();
                    for ( DomainEntryPoint fromTfsDomainEntryPoint : fromTfsDomainEntryPoints )
                    {
                        if ( fromTfsDomainEntryPoint != null )
                        {
                        	toCdsDomainEntryPoints.add( DomainEntryPointMapper.getInstance().map( fromTfsDomainEntryPoint ) );
                        }
                    }
                    toCdsTemplateMetaData.setDomainEntryPoints( toCdsDomainEntryPoints );
                }*/

        return toCdsFilterMetaData;
    }

}
