

package gov.va.med.cds.socket.server.handler;


import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.util.StringUtils;


public class MessageUtil
{

    public static final String MSH = "MSH";
    public static final String PID1 = "PID|1|";
    public static final String PID2 = "PID|2|";
    public static final String ALTONA_SITE = "503";
    public static final String LAB_MSG = "LA7LAB";


    public List<String> extractHl7Messages( String message, String msh )
    {
        List<String> msgsList = new ArrayList<String>();
        int pidCnt = 0;
        int i = 1;

        try
        {
            pidCnt = getPIDCount( message );

            if ( pidCnt > 1 )
            {

                StringBuffer extractedtMsg = new StringBuffer();
                StringBuffer remainingMsg = new StringBuffer();
                String newRemaniningMsg = null;
                String extractedPidMsg = null;
                String startIndex = null;
                String endIndex = null;
                while ( i <= pidCnt )
                {
                    //extract the first msg
                    if ( i == 1 )
                    {
                        extractedtMsg.append( message.substring( message.indexOf( MSH ), message.indexOf( PID2 ) - 1 ) );
                    }
                    else if ( i < pidCnt ) //remaining msgs
                    {
                        startIndex = "PID|" + i + "|";
                        endIndex = "PID|" + ( i + 1 ) + "|";// + "-2";
                        extractedtMsg = extractedtMsg.append( msh ).append( "\r" );
                        extractedPidMsg = remainingMsg.toString().substring( remainingMsg.toString().indexOf( startIndex ),
                                        remainingMsg.toString().indexOf( endIndex ) );

                        extractedtMsg = extractedtMsg.append( extractedPidMsg );

                        if ( StringUtils.hasLength( remainingMsg ) )
                        {
                            newRemaniningMsg = StringUtils.delete( remainingMsg.toString(), extractedPidMsg );

                            String newStr = extractedtMsg.toString().replace( startIndex, PID1 );
                            extractedtMsg.setLength( 0 );
                            extractedtMsg = extractedtMsg.append( newStr );

                        }

                    }
                    else if ( i == pidCnt )//last msg
                    {
                        startIndex = "PID|" + i + "|";

                        extractedtMsg = extractedtMsg.append( msh ).append( "\r" );
                        extractedPidMsg = remainingMsg.toString().substring( remainingMsg.toString().indexOf( startIndex ) );

                        extractedtMsg = extractedtMsg.append( extractedPidMsg );

                        if ( StringUtils.hasLength( remainingMsg ) )
                        {
                            //remove the extracted msg form the original msg
                            newRemaniningMsg = StringUtils.delete( remainingMsg.toString(), extractedPidMsg );

                            String newStr = extractedtMsg.toString().replace( startIndex, PID1 );
                            extractedtMsg.setLength( 0 );
                            extractedtMsg = extractedtMsg.append( newStr );

                        }

                    }

                    msgsList.add( extractedtMsg.toString() );

                    //remove extracted msg from the original message
                    if ( remainingMsg.length() == 0 )
                    {
                        remainingMsg = remainingMsg.append( StringUtils.delete( message, extractedtMsg.toString() ) );
                    }

                    else
                    {

                        remainingMsg.setLength( 0 );
                        remainingMsg = remainingMsg.append( newRemaniningMsg );

                    }

                    extractedtMsg.setLength( 0 );
                    i++ ;

                }
            }
            else
            {
                msgsList.add( message );//msg does not need procesing
            }

        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }
        return msgsList;
    }


    private int getPIDCount( String msgStr )
    {
        Pattern pattern = Pattern.compile( "PID\\|" );

        Matcher matcher = pattern.matcher( msgStr );

        int count = 0;

        while ( matcher.find() )
        {
            count++ ;

        }
        return count;
    }
}
