package gov.va.med.cds.socket.server.handler;

import gov.va.med.cds.hapi.HL7SupportInterface;

public class ChdrLegacyResponseGenerator
    extends
        AbstractResponseGenerator
{

    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.socket.server.handler.ResponseGeneratorInterface#createResponse(gov.va.med.cds.hapi.HL7SupportInterface, java.lang.String, java.lang.Exception)
     */
    public String createResponse( HL7SupportInterface hl7Support, String response, String responseMessageControlId, Exception exception )
    {
        if(exception == null)
        {
            return response;
        }
        else
        {
            return createErrorResponse( hl7Support );
        }
        
    }
    
    /**
     * Create a standard HL7 error response using values from the request if available
     * 
     * @param errMsg - Exception message string
     * @return String - A standard HL7 message
     */
    public String createErrorResponse( HL7SupportInterface hl7Support )
    {
        String sendingApplication = "";
        String sendingFacility = "";
        String messageDateTime = "";
        
        // Swallow any exceptions, thrown parsing individual fields. 
        try{sendingApplication = hl7Support.getSendingApplication();}catch (Exception ex) {};
        try{sendingFacility = hl7Support.getSendingFacility();}catch (Exception ex) {};
        try{messageDateTime = hl7Support.createMessageDateTime();}catch (Exception ex) {};
        
        return String.format( "BHS^~|\\&^VHA_HDR^^%s^%s^%s\rERR^OBR~~~100&SF\rBTS^0", sendingApplication, sendingFacility, messageDateTime );
    }

}
