

package gov.va.med.cds.mediator.xml.transform;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.mediator.work.MapBackedWorkState;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.mediator.work.WorkerInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.util.StreamUtil;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class Hl7XmlToVhimFilterTransformationTest
    extends
        AbstractBaseTest
{

    private WorkerInterface hl7XmlToFilterXmlWork;

    @Test
    @Suite( groups = { "smoketest" } )
    public void convertAlgyHl7XmltoVhimFilterTest( )
        throws Exception
    {
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/rdi-allergies.txt" ) );
        String vhimExpected = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/expected-vhim-filters/rdi-allergies-filter.xml" ) );

        String vhimActual = doTransformation( request );
        XmlComparator.assertXMLSimilar( vhimExpected, vhimActual );
    }
    
    @Test
    @Suite( groups = { "smoketest" } )
    public void convertRXHl7XmltoVhimFilterTest( )
        throws Exception
    {
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/rdi-meds.txt" ) );
        String vhimExpected = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/expected-vhim-filters/rdi-meds-filter.xml" ) );

        String vhimActual = doTransformation( request );
        XmlComparator.assertXMLSimilar( vhimExpected, vhimActual );
    }

    @Test
    @Suite( groups = { "smoketest" } )
    public void convertChdrAlgyHl7XmltoVhimFilterTest( )
        throws Exception
    {
        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/chdr-allergies.txt" ) );
        String vhimExpected = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/expected-vhim-filters/chdr-allergies-filter.xml" ) );

        String vhimActual = doTransformation( request );
        XmlComparator.assertXMLSimilar( vhimExpected, vhimActual );
    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void convertChdrRxOpHl7XmltoVhimFilterTest( )
        throws Exception
    {

        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/chdr-meds.txt" ) );
        String vhimExpected = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/expected-vhim-filters/chdr-meds-filter.xml" ) );

        String vhimActual = doTransformation( request );
        XmlComparator.assertXMLSimilar( vhimExpected, vhimActual );

    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void convertChdrLabHl7XmltoVhimFilterTest( )
        throws Exception
    {

        String request = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/er7-read-requests/chdr-lab.txt" ) );
        String vhimExpected = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/filter-creation-tests/expected-vhim-filters/chdr-lab-filter.xml" ) );

        String vhimActual = doTransformation( request );
        XmlComparator.assertXMLSimilar( vhimExpected, vhimActual );

    }

    // @Test( groups = { "checkintest" } )
    // public void convert_OR_VWVS2_Hl7XmltoVhimFilterTest( )
    // throws FileNotFoundException,
    // IOException
    // {
    //
    // File er7RequestMessage = new File( "./src/test/resources/hl7ReadRequestXml/OR_VWVS2.xml" );
    //
    // hl7RequestXmlToVhimFilterXmlMessageProcessor.processMessage( StreamUtil.streamAsString( new FileReader(
    // er7RequestMessage ) ) );
    // }

    // @Test( groups = { "checkintest" }, expectedExceptions = { MessageProcessorException.class } )
    // public void convertHl7XmlWithErrorstoVhimFilterTest( )
    // throws FileNotFoundException,
    // IOException
    // {
    //
    // File er7RequestMessages = new File( "./src/test/resources/hl7ReadRequestXmlWithErrors" );
    //
    // for ( String er7RequestMessage : er7RequestMessages.list() )
    // {
    // hl7RequestXmlToVhimFilterXmlMessageProcessor.processMessage( StreamUtil.streamAsString( new FileReader(
    // "./src/test/resources/hl7ReadRequestXmlWithErrors/" + er7RequestMessage ) ) );
    // }
    // }

    private String doTransformation( String er7EncodedRequest )
    {
        // set up work state
        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( er7EncodedRequest );
        workState.registerWorkState( "HL7-SUPPORT", hl7Support );

        hl7XmlToFilterXmlWork.doWork( workState );

        return ( String )workState.locateWorkState( "VHIM-REQUEST" );
    }


    @Resource
    public void setHl7XmlToFilterXmlWork( WorkerInterface hl7XmlToFilterXmlWork )
    {
        this.hl7XmlToFilterXmlWork = hl7XmlToFilterXmlWork;
    }
}
