

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class Hl7SupportExceptionTest
{

    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testHL7SupportException( )
    {
        throw new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_PARSE_EXCEPTION );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testHL7SupportExceptionCustomMessage( )
    {
        throw new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_PARSE_EXCEPTION, "MSH-3 Segment Parse Exception" );
    }


    @Test( expected = HL7SupportException.class )
    @Suite( groups = { "checkintest" } )
    public void testHL7SupportExceptionThrownMessageCustomMessage( )
    {
        throw new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_PARSE_EXCEPTION, new Throwable( "MSH-3 Segment Parse Exception" ),
                        "MSH-3 Segment Parse Exception" );
    }
}
