

package gov.va.med.cds.mediator.work.cds;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.mediator.work.FilterInformation;
import gov.va.med.cds.mediator.work.MapBackedWorkState;
import gov.va.med.cds.mediator.work.WorkStateException;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.io.IOException;

import javax.annotation.Resource;


@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class ClinicalDataReadMessageProcessorTest
    extends
        AbstractBaseTest
{

    private static final String TEMPLATE_NAME = "TEMPLATE-NAME";
    private static final String REQUEST = "REQUEST";
    private static final String FILTER_ID = "FILTER-ID";
    private static final String MESSAGE_CONTROL_ID = "MESSAGE-CONTROL-ID";
    private static final String RESPONSE = "RESPONSE";

    private ClinicalDataReadMessageWork clinicalDataReadMessageWork;


    @Test
    @Suite( groups = { "checkintest" } )
    public void testProcessMessage( )
        throws IOException
    {
        // create the mock object to use for the test.
        ClinicalDataServiceSynchronousInterface cdsSynchronous = EasyMock.createMock( ClinicalDataServiceSynchronousInterface.class );
        EasyMock.expect( cdsSynchronous.readClinicalData( TEMPLATE_NAME, REQUEST, FILTER_ID, MESSAGE_CONTROL_ID ) ).andReturn( RESPONSE );
        EasyMock.replay( cdsSynchronous );

        clinicalDataReadMessageWork.setCdsSynchronous( cdsSynchronous );

        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        EasyMock.expect( hl7Support.getMessageControlId() ).andReturn( MESSAGE_CONTROL_ID );
        EasyMock.replay( hl7Support );

        FilterInformation filterInformation = new FilterInformation();
        filterInformation.setFilterId( FILTER_ID );
        filterInformation.setTemplateId( TEMPLATE_NAME );

        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "FILTER-INFO", filterInformation );
        workState.registerWorkState( "HL7-SUPPORT", hl7Support );
        workState.registerWorkState( "VHIM-REQUEST", REQUEST );

        clinicalDataReadMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "VHIM-RESPONSE" );
        assertEquals( workStateResponse, RESPONSE );

    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testMissingFilterInformation( )
    {
        // create the mock object to use for the test.
        ClinicalDataServiceSynchronousInterface cdsSynchronous = EasyMock.createMock( ClinicalDataServiceSynchronousInterface.class );
        EasyMock.expect( cdsSynchronous.readClinicalData( TEMPLATE_NAME, REQUEST, FILTER_ID, MESSAGE_CONTROL_ID ) ).andReturn( RESPONSE );
        EasyMock.replay( cdsSynchronous );

        clinicalDataReadMessageWork.setCdsSynchronous( cdsSynchronous );

        FilterInformation filterInformation = new FilterInformation();
        filterInformation.setFilterId( FILTER_ID );
        filterInformation.setTemplateId( TEMPLATE_NAME );

        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "FILTER-INFO", filterInformation );
        workState.registerWorkState( "VHIM-REQUEST", REQUEST );

        clinicalDataReadMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "VHIM-RESPONSE" );
        assertEquals( workStateResponse, RESPONSE );
    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testMissingHL7Support( )
    {
        // create the mock object to use for the test.
        ClinicalDataServiceSynchronousInterface cdsSynchronous = EasyMock.createMock( ClinicalDataServiceSynchronousInterface.class );
        EasyMock.expect( cdsSynchronous.readClinicalData( TEMPLATE_NAME, REQUEST, FILTER_ID, MESSAGE_CONTROL_ID ) ).andReturn( RESPONSE );
        EasyMock.replay( cdsSynchronous );

        clinicalDataReadMessageWork.setCdsSynchronous( cdsSynchronous );

        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        EasyMock.expect( hl7Support.getMessageControlId() ).andReturn( MESSAGE_CONTROL_ID );
        EasyMock.replay( hl7Support );

        WorkStateInterface workState = new MapBackedWorkState();
        workState.registerWorkState( "HL7-SUPPORT", hl7Support );
        workState.registerWorkState( "VHIM-REQUEST", REQUEST );

        clinicalDataReadMessageWork.doWork( workState );

        String workStateResponse = ( String )workState.locateWorkState( "VHIM-RESPONSE" );
        assertEquals( workStateResponse, RESPONSE );
    }


    @Resource
    public void setClinicalDataReadMessageWork( ClinicalDataReadMessageWork clinicalDataReadMessageWork )
    {
        this.clinicalDataReadMessageWork = clinicalDataReadMessageWork;
    }

}
