

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class WorkStateExceptionTest
{
    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testWorkStateExceptionErrorCode( )
    {
        throw new WorkStateException( ErrorCodeEnum.MIGRATOR_MESSAGE_PROCESSOR );
    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testWorkStateExceptionErrorCodeThrowable( )
    {
        throw new WorkStateException( ErrorCodeEnum.MIGRATOR_MESSAGE_PROCESSOR, new Throwable( "Source is NULL" ) );
    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testWorkStateExceptionErrorCodeThrowableCustomMessage( )
    {
        throw new WorkStateException( ErrorCodeEnum.MIGRATOR_MESSAGE_PROCESSOR, new Throwable( "Source is NULL" ), "MSH3 segment is NULL" );
    }
}
