

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import junit.framework.Assert;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class RequestResponseWorkFlowTest
{
    RequestResponseWorkFlow workFlow = new RequestResponseWorkFlow();


    /***
     * processMessageTest forces RequestResponseWorkFlow to throw an exception with a null string for its input.
     */
    @Test
    @Suite( groups = { "checkintest" } )
    public void processMessageTest( )
    {
        int size = 0;

        workFlow.setWsnInputMessage( "INPUT-MESSAGE" );
        workFlow.setWsnOutputMessage( "OUTPUT-MESSAGE" );
        workFlow.setWsnPersistOriginal( "PERSIST-ORIGINAL" );

        String errorSection = workFlow.processMessage( "Force Exception to be thrown", true );
        Assert.assertTrue( workFlow.processMessage( null, true ).contains( "CATASTROPHIC" ) );

        try
        {
            Document docObj = DocumentHelper.parseText( errorSection );
            size = docObj.selectNodes( "//clinicaldata:ClinicalData/errorSection/*" ).size();

        }
        catch ( DocumentException e )
        {
            e.printStackTrace();
        }

        Assert.assertTrue( size > 0 );
        Assert.assertTrue( size == 1 );

    }

}
