

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.audit.LegacyReadAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ReadRequestAuditLogEndWorkTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDoWorkWithFailure( )
    {
        RuntimeException runtimeException = new IllegalArgumentException( "My bogus runtime exception." );
        ReadRequestAuditLogEndWork auditLogEndWork = new ReadRequestAuditLogEndWork();

        WorkStateInterface workState = EasyMock.createMock( WorkStateInterface.class );
        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        EasyMock.expect( hl7Support.getStationNumber() ).andReturn( "505" );
//        EasyMock.expect( hl7Support.getRequestWhatCode() ).andReturn( "WhatCode" );
        EasyMock.expect( hl7Support.getMessageControlId() ).andReturn( "ControlId" );
        EasyMock.expect( hl7Support.getSendingApplication() ).andReturn( "Allergies" );

        EasyMock.expect( workState.locateWorkState( "wsnHl7Support" ) ).andReturn( hl7Support );
//        EasyMock.expect( workState.locateWorkState( "wsnMessage" ) ).andReturn( "MESSAGE TEXT" );
        EasyMock.expect( workState.locateWorkState( "wsnMessage" ) ).andReturn( "<?xml version=\"1.0\" encoding=\"UTF-8\"?><message>MESSAGE TEXT\"</message>");       
        EasyMock.expect( workState.locateWorkState( "wsnStartTimeInMillis" ) ).andReturn( new Long( 23333 ) );
        EasyMock.expect( workState.locateWorkState( "wsnCdsLegacyResponse" ) ).andThrow( runtimeException );
        FilterInformation filterInformation = new FilterInformation( );
        filterInformation.setFilterId( "filterId" );
        filterInformation.setTemplateId( "templateId" );
        EasyMock.expect( workState.locateWorkState( "wsnFilterInformation" ) ).andReturn( filterInformation );
        workState.addException( runtimeException );

        AuditLogPersistenceManagerInterface auditLogPersistenceManager = EasyMock.createNiceMock( AuditLogPersistenceManagerInterface.class );
        auditLogPersistenceManager.storeAuditLog( ( LegacyReadAuditLog )EasyMock.anyObject() );
        EasyMock.expectLastCall();
        EasyMock.replay( hl7Support, workState, auditLogPersistenceManager );

        auditLogEndWork.setWsnHl7Support( "wsnHl7Support" );
        auditLogEndWork.setWsnMessage( "wsnMessage" );
        auditLogEndWork.setWsnStartTimeInMillis( "wsnStartTimeInMillis" );
        auditLogEndWork.setWsnCdsLegacyResponse( "wsnCdsLegacyResponse" );
        auditLogEndWork.setAuditLogPersistenceManager( auditLogPersistenceManager );
        auditLogEndWork.setWsnFilterInformation( "wsnFilterInformation" );

        auditLogEndWork.doWork( workState );

        EasyMock.verify( hl7Support, workState, auditLogPersistenceManager );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testDoWork( )
    {
        ReadRequestAuditLogEndWork auditLogEndWork = new ReadRequestAuditLogEndWork();

        WorkStateInterface workState = EasyMock.createMock( WorkStateInterface.class );
        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        EasyMock.expect( hl7Support.getStationNumber() ).andReturn( "505" );
//        EasyMock.expect( hl7Support.getRequestWhatCode() ).andReturn( "WhatCode" );
        EasyMock.expect( hl7Support.getMessageControlId() ).andReturn( "ControlId" );
        EasyMock.expect( hl7Support.getSendingApplication() ).andReturn( "Allergies" );

        EasyMock.expect( workState.locateWorkState( "wsnHl7Support" ) ).andReturn( hl7Support );
//        EasyMock.expect( workState.locateWorkState( "wsnMessage" ) ).andReturn( "MESSAGE TEXT" );
        EasyMock.expect( workState.locateWorkState( "wsnMessage" ) ).andReturn( "<?xml version=\"1.0\" encoding=\"UTF-8\"?><message>MESSAGE TEXT\"</message>");
        EasyMock.expect( workState.locateWorkState( "wsnStartTimeInMillis" ) ).andReturn( new Long( 23333 ) );
        EasyMock.expect( workState.locateWorkState( "wsnCdsLegacyResponse" ) ).andReturn( "MESSAGE RESPONSE" );
        FilterInformation filterInformation = new FilterInformation( );
        filterInformation.setFilterId( "filterId" );
        filterInformation.setTemplateId( "templateId" );
        EasyMock.expect( workState.locateWorkState( "wsnFilterInformation" ) ).andReturn( filterInformation );

        AuditLogPersistenceManagerInterface auditLogPersistenceManager = EasyMock.createNiceMock( AuditLogPersistenceManagerInterface.class );
        auditLogPersistenceManager.storeAuditLog( ( LegacyReadAuditLog )EasyMock.anyObject() );
        EasyMock.expectLastCall();
        EasyMock.replay( hl7Support, workState, auditLogPersistenceManager );

        auditLogEndWork.setWsnHl7Support( "wsnHl7Support" );
        auditLogEndWork.setWsnMessage( "wsnMessage" );
        auditLogEndWork.setWsnStartTimeInMillis( "wsnStartTimeInMillis" );
        auditLogEndWork.setWsnCdsLegacyResponse( "wsnCdsLegacyResponse" );
        auditLogEndWork.setAuditLogPersistenceManager( auditLogPersistenceManager );
        auditLogEndWork.setWsnFilterInformation( "wsnFilterInformation" );

        auditLogEndWork.doWork( workState );

        EasyMock.verify( hl7Support, workState, auditLogPersistenceManager );

    }

}
