

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.HashMap;
import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class Er7MessageUtilTest
{
    private static final String RESPONSE_MESSAGE = "{MESSAGE-CONTROL-ID}{REQUEST-MESSAGE-CONTROL-ID}{MESSAGE-DATE-TIME}";
    String result = null;
    String expectedResult = null;


    @Test
    @Suite( groups = { "checkintest" } )
    public void testReplaceMessageControlId( )
    {
        expectedResult = "MSG_CTRL_ID{REQUEST-MESSAGE-CONTROL-ID}{MESSAGE-DATE-TIME}";

        result = Er7MessageUtil.replaceMessageControlId( RESPONSE_MESSAGE, null );
        Assert.assertEquals( result, RESPONSE_MESSAGE );

        result = Er7MessageUtil.replaceMessageControlId( RESPONSE_MESSAGE, "MSG_CTRL_ID" );
        Assert.assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testReplaceRequestMessageControlId( )
    {
        expectedResult = "{MESSAGE-CONTROL-ID}RQST_MSG_CTRL_ID{MESSAGE-DATE-TIME}";

        result = Er7MessageUtil.replaceRequestMessageControlId( RESPONSE_MESSAGE, null );
        Assert.assertEquals( result, RESPONSE_MESSAGE );

        result = Er7MessageUtil.replaceRequestMessageControlId( RESPONSE_MESSAGE, "RQST_MSG_CTRL_ID" );
        Assert.assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testReplaceMessageDateTime( )
    {
        expectedResult = "{MESSAGE-CONTROL-ID}{REQUEST-MESSAGE-CONTROL-ID}MSG_DT_TIME";

        result = Er7MessageUtil.replaceMessageDateTime( RESPONSE_MESSAGE, null );
        Assert.assertEquals( result, RESPONSE_MESSAGE );

        result = Er7MessageUtil.replaceMessageDateTime( RESPONSE_MESSAGE, "MSG_DT_TIME" );
        Assert.assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testReplaceValues( )
    {
        Map<String, String> replacementAndValues = new HashMap<String, String>();
        replacementAndValues.put( "{MESSAGE-CONTROL-ID}", "MSG_CTRL_ID" );
        replacementAndValues.put( "{REQUEST-MESSAGE-CONTROL-ID}", "RQST_MSG_CTRL_ID" );
        replacementAndValues.put( "{MESSAGE-DATE-TIME}", "MSG_DT_TIME" );

        expectedResult = "MSG_CTRL_IDRQST_MSG_CTRL_IDMSG_DT_TIME";

        result = Er7MessageUtil.replaceValues( RESPONSE_MESSAGE, replacementAndValues );
        Assert.assertEquals( result, expectedResult );
    }
}
