

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ApplicationAcknowledgementWorkTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDoWork( )
    {
        ApplicationAcknowledgementWork applicationAcknowledgementWork = new ApplicationAcknowledgementWork();

        String wsnHl7Support = "wsnHl7Support";
        applicationAcknowledgementWork.setWsnHl7Support( wsnHl7Support );

        String wsnCdsVhimResponse = "wsnCdsVhimResponse";
        applicationAcknowledgementWork.setWsnCdsVhimResponse( wsnCdsVhimResponse );

        Map<String, NetworkClientProxyInterface> clientProxiesMap = new HashMap<String, NetworkClientProxyInterface>();
        applicationAcknowledgementWork.setClientProxiesMap( clientProxiesMap );

        List<Exception> exceptionList = new ArrayList<Exception>();

        boolean isEnabled = true;
        applicationAcknowledgementWork.setEnabled( isEnabled );

        String vhimResponse = "vhimResponse";
        String appAck = "appAck";

        HL7SupportInterface hL7SupportInterfaceMock = EasyMock.createMock( HL7SupportInterface.class );
        EasyMock.expect( hL7SupportInterfaceMock.getApplicationAcknowledgement( exceptionList, vhimResponse, null ) ).andReturn( appAck );
        EasyMock.expect( hL7SupportInterfaceMock.getSendingFacility() ).andReturn( "200CH" );
        EasyMock.expect( hL7SupportInterfaceMock.getSendingFacility() ).andReturn( "SendingFacility" );
        EasyMock.expect( hL7SupportInterfaceMock.getSendingApplication() ).andReturn( "SendingApplication" );

        WorkStateInterface workStateInterfaceMock = EasyMock.createMock( WorkStateInterface.class );
        EasyMock.expect( workStateInterfaceMock.locateWorkState( wsnHl7Support ) ).andReturn( hL7SupportInterfaceMock );
        EasyMock.expect( workStateInterfaceMock.locateWorkState( wsnCdsVhimResponse ) ).andReturn( vhimResponse );
        EasyMock.expect( workStateInterfaceMock.getExceptions() ).andReturn( exceptionList );

        EasyMock.replay( new Object[] { hL7SupportInterfaceMock, workStateInterfaceMock } );
        applicationAcknowledgementWork.doWork( workStateInterfaceMock );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testIsEnabled( )
    {
        ApplicationAcknowledgementWork applicationAcknowledgementWork = new ApplicationAcknowledgementWork();
        Assert.assertTrue( applicationAcknowledgementWork.isEnabled() );

        applicationAcknowledgementWork.setEnabled( false );
        Assert.assertTrue( !applicationAcknowledgementWork.isEnabled() );

        applicationAcknowledgementWork.setEnabled( false );
        applicationAcknowledgementWork.doWork( null );
    }
}
