

package gov.va.med.cds.aspects.exception;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;


/**
 * @author susarlan
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:config/exception/test-swallow-context.xml" } )
public class MediatorSwallowAspectTests
    extends
        AbstractBaseTest
{
    //private AccessValidatorInterface mllpAccessValidator;

    private static String icReadResponseWithErrorSection = null;
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;
    private static ResourceLoader resourceLoader = null;
    private static Resource resource = null;


    /***
     * Swallows the exception thrown when validate access throws an exception
     * @throws Exception
     */
    //    @Test( groups = { "checkintest" } )
    //    public void testSwallow( )
    //        throws Exception
    //    {
    //        String hl7Request = null;
    //        mllpAccessValidator.validateAccess( hl7Request );
    //    }
    /***
     * Swallows the exception thrown when the response contains an error section
     * @throws Exception
     */
    @Test
    @Suite( groups = { "checkintest" } )
    public void testSwallowErrorMessages( )
        throws Exception
    {
        responseErrorSectionExtractor.checkForErrorsInResponse( icReadResponseWithErrorSection );
    }


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeMediatorSwallowAspectTestsClassSetUp( )
        throws Exception
    {

        resourceLoader = new DefaultResourceLoader();
        resource = resourceLoader.getResource( "file:src/test/resources/response/AllergyRead400IntoleranceConditionWithConstraintViolation.xml" );
        icReadResponseWithErrorSection = StreamUtil.resourceToString( resource );
    }


    @AfterClass
    @Suite( groups = { "checkintest" } )
    public static void afterMediatorSwallowAspectTestsClassSetUp( )
        throws Exception
    {

        resourceLoader = null;
        resource = null;
        icReadResponseWithErrorSection = null;
    }


    //    @javax.annotation.Resource
    //  public void setMllpAccessValidator(AccessValidatorInterface mllpAccessValidator)
    //    {
    //      this.mllpAccessValidator = mllpAccessValidator;
    //  }

    @javax.annotation.Resource
    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }
}
