/**
 * 
 */


package gov.va.med.cds.aspects.exception;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;


/**
 * @author susarlan
 * 
 */
@ContextConfiguration( locations = { "classpath:config/exception/test-log-and-swallow-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class MediatorLogAndSwallowAspectTests
    extends
        AbstractBaseTest
{

    static String icReadResponseWithErrorSection = null;
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;
    private static ResourceLoader resourceLoader;
    private static Resource resource = null;


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeMediatorLogAndSwallowAspectTestsClassSetUp( )
        throws Exception
    {

        resourceLoader = new DefaultResourceLoader();

        resource = resourceLoader.getResource( "file:src/test/resources/response/AllergyRead400IntoleranceConditionWithConstraintViolation.xml" );
        icReadResponseWithErrorSection = StreamUtil.resourceToString( resource );
    }


    @AfterClass
    @Suite( groups = { "checkintest" } )
    public static void AfterMediatorLogAndSwallowAspectTestsClassSetUp( )
        throws Exception
    {

        resourceLoader = null;

        resource = null;
        icReadResponseWithErrorSection = null;
    }


    /***
     * Logs and Swallows the exception thrown when the response contains an
     * error section
     * 
     * @throws Exception
     */

    @Test
    @Suite( groups = { "checkintest" } )
    public void testLogAndSwallowDuplicate( )
        throws Exception
    {
        responseErrorSectionExtractor.checkForErrorsInResponse( icReadResponseWithErrorSection );
    }


    @javax.annotation.Resource
    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }

}
