<?xml version="1.0" encoding="UTF-8"?>
<!-- $Author: vhaislshaha $ -->
<!-- $DateTime: 2014/10/02 14:48:57 $ -->
<!-- $File: //repositories/apps/mediator/branches/rtc/mediator/src/main/resources/xslts/vhim400/HL7ToVitalSigns.xsl $ -->
<!-- $Revision: #1 $ -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:vitalsigns="VitalSigns" xmlns:b="urn:hl7-org:v2xml" xmlns:common="Common" xmlns:act="Act" xmlns:participation="Participation" xmlns:person="Person" xmlns:exposure="Exposure" xmlns:vhimdatatypes="VHIMDatatypes" xmlns:entity="Entity" xmlns:observation="Observation" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata">
			<templateId>VitalsignsCreateOrUpdate40060</templateId>
			<patient>
				<xsl:variable name="nationalId" select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'NI'][1]/b:CX.1"/>
				<xsl:if test="string-length($nationalId) > 0">
					<requestedNationalId>
						<xsl:value-of select="$nationalId"/>
					</requestedNationalId>
				</xsl:if>		
				<xsl:for-each select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.ORDER_OBSERVATION">
					<vitalSignObservationEvents>
						<xsl:for-each select="b:ORC/b:ORC.3">
							<xsl:call-template name="getRecordIdentifier"/>
						</xsl:for-each>
						<xsl:for-each select="../b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'PI']">
							<xsl:call-template name="getPatientLite"/>
						</xsl:for-each>
						<xsl:if test="(b:OBR/b:OBR.7/b:TS.1 != '') ">
							<observationTime>
								<literal>
									<xsl:value-of select="b:OBR/b:OBR.7/b:TS.1"/>
								</literal>
							</observationTime>
						</xsl:if>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX/b:OBX.3[b:CNE.2  != '']">
							<observedCharacteristic>
								<xsl:call-template name="getCodedElementLite">
									<xsl:with-param name="theCode" select="."/>
								</xsl:call-template>
							</observedCharacteristic>
						</xsl:for-each>
						<collectionSessionTime>
							<literal>
								<xsl:value-of select="b:OBR/b:OBR.22/b:TS.1"/>
							</literal>
						</collectionSessionTime>
						<status>
							<xsl:value-of select="b:OBR/b:OBR.25"/>
						</status>
						<xsl:if test="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'O2 Supplement']">
							<supplementalOxygen>
								<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'O2 Supplement' and b:OBX.6/b:CE.1 != '%' ]">
									<flowRateValue>
										<xsl:value-of select="b:OBX.5"/>
									</flowRateValue>
									<flowRateUnit>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="b:OBX.6"/>
										</xsl:call-template>
									</flowRateUnit>
								</xsl:for-each>
								<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'O2 Supplement' and b:OBX.6/b:CE.1 = '%' ]">
									<concentrationValue>
										<xsl:value-of select="b:OBX.5"/>
									</concentrationValue>
									<concentrationUnit>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="b:OBX.6"/>
										</xsl:call-template>
									</concentrationUnit>
								</xsl:for-each>
							</supplementalOxygen>
						</xsl:if>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.2  != '']">
							<xsl:variable name="author">
								<author>
									<xsl:call-template name="getPractitioner">
										<xsl:with-param name="thePractitioner" select="b:OBX.16"/>
									</xsl:call-template>
								</author>
							</xsl:variable>
							<xsl:if test="string-length($author) > 0">
								<author>
									<xsl:call-template name="getPractitioner">
										<xsl:with-param name="thePractitioner" select="b:OBX.16"/>
									</xsl:call-template>
								</author>
							</xsl:if>
						</xsl:for-each>
						<hospitalLocationIdentifier>
							<pointOfCare>
								<xsl:value-of select="b:ORC/b:ORC.13/b:PL.1"/>
							</pointOfCare>
							<room>
								<xsl:value-of select="b:ORC/b:ORC.13/b:PL.2"/>
							</room>
							<locationDescription>
								<xsl:value-of select="b:ORC/b:ORC.13/b:PL.9"/>
							</locationDescription>
						</hospitalLocationIdentifier>
						<division>
							<xsl:call-template name="getCodedElementLite">
								<xsl:with-param name="theCode" select="b:ORC/b:ORC.17"/>
							</xsl:call-template>
						</division>
						<orderingFacilityIdentifier>
							<name>
								<xsl:value-of select="b:ORC/b:ORC.21/b:XON.1"/>
							</name>
						</orderingFacilityIdentifier>
						<stopCode>
							<code>
								<xsl:value-of select="b:ORU_R01.OBSERVATION/b:ZSC/b:ZSC.2"/>
							</code>
							<displayText>
								<xsl:value-of select="b:ORU_R01.OBSERVATION/b:ZSC/b:ZSC.3"/>
							</displayText>
						</stopCode>
						<vitalSignObservation>
							<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.2  != '']">
								<value>
									<xsl:value-of select="b:OBX.5"/>
								</value>
								<unit>
									<xsl:call-template name="getCodedElementLite">
										<xsl:with-param name="theCode" select="b:OBX.6"/>
									</xsl:call-template>
								</unit>
								<xsl:for-each select="../../b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 ='Qualifiers']">
									<xsl:for-each select="b:OBX.5">
										<qualifier>
											<value>
												<xsl:call-template name="getCodedElementLite">
													<xsl:with-param name="theCode" select="."/>
												</xsl:call-template>
											</value>
										</qualifier>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</vitalSignObservation>
						<xsl:for-each select="b:ORU_R01.OBSERVATION/b:OBX[b:OBX.3/b:CNE.1 = 'Error Reasons']">
							<errorEnterer>
								<xsl:call-template name="getPractitioner">
									<xsl:with-param name="thePractitioner" select="b:OBX.16"/>
								</xsl:call-template>
							</errorEnterer>
							<xsl:for-each select="b:OBX.5">
								<errorReason>
									<reason>
										<xsl:call-template name="getCodedElementLite">
											<xsl:with-param name="theCode" select="."/>
										</xsl:call-template>
									</reason>
								</errorReason>
							</xsl:for-each>
						</xsl:for-each>
						<xsl:for-each select="/b:ORU_R01/b:MSH">
							<xsl:call-template name="getRecordInformation"/>
						</xsl:for-each>
					</vitalSignObservationEvents>
				</xsl:for-each>
			</patient>
		</clinicaldata:ClinicalData>
	</xsl:template>
	<!--
		####################################################################################
		################# COMMON TEMPLATES ###############################################

		getRecordIdentifier template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getRecordIdentifier">
		<xsl:if test="((b:EI.1 != '') and (b:EI.2 != ''))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="b:EI.1"/>
				</identity>
				<namespaceId>
					<xsl:value-of select="b:EI.2"/>
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	<!--
		####################################################################################

		getPatientLite template
		applies to PID/b:PID.3[b:CX.5 = 'PI'] path

	-->
	<xsl:template name="getPatientLite">
		<xsl:if test="((b:CX.1 != '') and (b:CX.6/b:HD.2 != '') and (b:CX.4/b:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="b:CX.1"/>
					</identity>
					<assigningFacility>
						<xsl:value-of select="b:CX.6/b:HD.2"/>
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="b:CX.4/b:HD.1"/>
					</assigningAuthority>
				</identifier>
				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->
				<xsl:choose>
					<xsl:when test="../b:PID.5[b:XPN.7 = 'L']">
						<name>
							<given>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.1/b:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.4"/>
							</suffix>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../b:PID.5[1]/b:XPN.1/b:FN.1">
							<name>
								<given>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.2"/>
								</given>
								<middle>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.3"/>
								</middle>
								<family>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.1/b:FN.1"/>
								</family>
								<suffix>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.4"/>
								</suffix>
							</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template
		applies to MSH path

	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(b:MSH.4/b:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="b:MSH.4/b:HD.1"/>
				</namespaceId>
				<universalId>
					<xsl:value-of select="b:MSH.4/b:HD.2"/>
				</universalId>
				<universalIdType>
					<xsl:value-of select="b:MSH.4/b:HD.3"/>
				</universalIdType>
			</recordSource>
		</xsl:if>
		<recordVersion>0</recordVersion>
		<xsl:if test="(b:MSH.7/b:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="b:MSH.7/b:TS.1"/>
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
	<!--
		#########################################################
		
		getCodedElementLite template 
		applies to any path ending in CE or CNE and transforming CE.1/CNE.1, CE.2/CNE.2, and CE.3/CNE.3 into code, displayText, and codingSystem respectively
		
	-->
	<xsl:template name="getCodedElementLite">
		<xsl:param name="theCode"/>
		<code>
			<xsl:value-of select="$theCode/(b:CE.1 | b:CNE.1)"/>
		</code>
		<displayText>
			<xsl:value-of select="$theCode/(b:CE.2 | b:CNE.2)"/>
		</displayText>
		<codingSystem>
			<xsl:value-of select="$theCode/(b:CE.3 | b:CNE.3)"/>
		</codingSystem>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitioner template
		applies to any path ending in NDL and transforming NDL.1 through NDL.8 into the appropriate Pracitioner elements

	-->
	<xsl:template name="getPractitioner">
		<xsl:param name="thePractitioner"/>
		<practitioner>
			<identifier>
				<identity>
					<xsl:value-of select="$thePractitioner/b:XCN.1"/>
				</identity>
				<assigningFacility/>
			</identifier>
			<idSourceTable>
				<xsl:value-of select="$thePractitioner/b:XCN.8"/>
			</idSourceTable>
			<name>
				<prefix>
					<xsl:value-of select="$thePractitioner/b:XCN.6"/>
				</prefix>
				<given>
					<xsl:value-of select="$thePractitioner/b:XCN.3"/>
				</given>
				<middle>
					<xsl:value-of select="$thePractitioner/b:XCN.4"/>
				</middle>
				<family>
					<xsl:value-of select="$thePractitioner/b:XCN.2/b:FN.1"/>
				</family>
				<suffix>
					<xsl:value-of select="$thePractitioner/b:XCN.5"/>
				</suffix>
				<title>
					<xsl:value-of select="$thePractitioner/b:XCN.7"/>
				</title>
			</name>
		</practitioner>
	</xsl:template>
</xsl:stylesheet>
