

package gov.va.med.cds.scheduler.persistence;


import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.PersistenceException;


public class ExpiredCensusReportAcknowledgementPersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        ExpiredCensusReportAcknowledgementPersistenceInterface
{

    private static final Log LOGGER = LogFactory.getLog( ExpiredCensusReportAcknowledgementPersistenceManager.class );

    private static final String CENSUSMASTERINGEST_EXPIRED_REPORTS = "censusMasterIngest.list.expiredReports";
    private static final String CENSUSMASTERINGEST_UPDATE_INGESTSTATUS = "censusMasterIngest.update.ingestStatus";
    private static final String CENSUSCOMPLETEWEEK_MASTER_ID = "censusCompleteWeek.list.censusMasterId";
    private static final String CENSUSCOMPLETEWEEK_UPDATE_INGESTSTATUS = "censusCompleteWeek.update.ingestStatus";
    private static final String CENSUSMASTERINGEST_UPDATE_ACKSTATUS = "censusMasterIngest.update.ackStatus";
    private static final String CENSUSCOMPLETEWEEK_UPDATE_ACKSTATUS = "censusCompleteWeek.update.ackStatus";
    private static final String ACKSTATUS_SENT = "SENT";


    @SuppressWarnings( { "unchecked", "unused" } )
    @Override
    public void sendAckForExpiredCensusReport( )
        throws PersistenceException
    {
        Session session = null;
        long censusMasterId = 0;
        int updatedEntities = 0;
        String vendorFacility = null;
        Date reportStartDt = null;
        CensusCompleteWeek censusCompleteWeek = null;
        CensusCompleteWeek censusCmplWeek = null;
        Query updateStsQuery = null;
        Query censusCompleteWeekQuery = null;
        long censusCompleteWeekId = 0;
        
        try
        {
            session = getSessionFactory().getCurrentSession();

            Query expiredReportsQuery = session.getNamedQuery( CENSUSMASTERINGEST_EXPIRED_REPORTS );
            List<CensusMasterIngest> expiredReports = expiredReportsQuery.list();

            for ( CensusMasterIngest censusMasterIngest : expiredReports )
            {
                censusMasterId = censusMasterIngest.getCensusMasterId();
                vendorFacility = censusMasterIngest.getVendorFacility();
                reportStartDt = censusMasterIngest.getReportStartDt();

                updateStsQuery = session.getNamedQuery( CENSUSMASTERINGEST_UPDATE_INGESTSTATUS );
                updatedEntities = updateStsQuery.setParameter( "censusMasterId", censusMasterId ).executeUpdate();
            
                //:vendorFacility and ccw.reportStartDt = :reportStartDt
                censusCompleteWeek = new CensusCompleteWeek();
                censusCompleteWeek.setVendorFacility( censusMasterIngest.getVendorFacility() );
                censusCompleteWeek.setReportStartDt( censusMasterIngest.getReportStartDt() );

                censusCompleteWeekQuery = session.getNamedQuery( CENSUSCOMPLETEWEEK_MASTER_ID );
                censusCompleteWeekQuery.setParameter( "vendorFacility", vendorFacility );
                censusCompleteWeekQuery.setDate( "reportStartDt", reportStartDt );
                List<CensusCompleteWeek> ccwList = censusCompleteWeekQuery.list();

                censusCmplWeek = ( null != ccwList && ccwList.size() > 0 ) ? ccwList.get( 0 ) : null;

                if ( null != censusCmplWeek )
                {
                    censusCompleteWeekId = censusCmplWeek.getCensusCompleteWeekId();
                    updatedEntities = session.getNamedQuery( CENSUSCOMPLETEWEEK_UPDATE_INGESTSTATUS ).setParameter( "censusCompleteWeekId", censusCompleteWeekId ).executeUpdate();

                    censusAcknowledgementWork.sendCensusAcknowledgement( censusCmplWeek, censusMasterId );
                    
                    //update ackStatus to 'SENT'
                    updatedEntities = session.getNamedQuery( CENSUSMASTERINGEST_UPDATE_ACKSTATUS )
                                    .setParameter( "ackStatus", ACKSTATUS_SENT )
                                    .setParameter( "censusMasterId", censusMasterId )
                                    .executeUpdate();
                    updatedEntities = session.getNamedQuery( CENSUSCOMPLETEWEEK_UPDATE_ACKSTATUS )
                                    .setParameter( "ackStatus", ACKSTATUS_SENT )
                                    .setParameter( "censusCompleteWeekId", censusCompleteWeekId )
                                    .executeUpdate();
                }
            }
        }
        catch ( Exception e )
        {
            LOGGER.error( "Error in sendAckForExpiredCensusReport" + e );
            throw new PersistenceException( ErrorCodeEnum.ERROR_IN_PERSISTENCE_LAYER, e );
        }
    }
}
