

package gov.va.med.cds.scheduler.persistence;


import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

import gov.va.med.cds.exception.CensusTransformAckException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.PersistenceException;


public class CensusTransformationAcknowledgementPersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        CensusTransformationAcknowledgementPersistenceInterface
{

    private static final Log LOGGER = LogFactory.getLog( CensusTransformationAcknowledgementPersistenceManager.class );

    private static final String OSP_TRANSFORM_ACK_BUILD = "Census_Ingest_Processing.Transform_Ack_Build";
    private static final String OSP_TRANSFORM_ACK_COMPLETE = "Census_Ingest_Processing.Transform_Ack_Complete";

    private static final String ACK_FLAG_READY = "READY";
    private static final String ACK_FLAG_SENT = "SENT";
    
    @SuppressWarnings( "unchecked" )
    @Override
    public void sendAckForTransformedCensusReport( )
        throws PersistenceException
    {
        Session session = null;
        Transaction tx = null;
        Query query = null;
        List<CensusAcknowledgementResponse> transformResponses = null;
        Query queryAckUpdate = null;
        long censusMasterId = 0;

        try
        {
            session = getSessionFactory().getCurrentSession();
            tx = session.getTransaction();
            query = session.getNamedQuery( OSP_TRANSFORM_ACK_BUILD );

            transformResponses = query.list();

            if (null != transformResponses && transformResponses.size() > 0) {
                for ( CensusAcknowledgementResponse transformResponse : transformResponses )
                {
                    try
                    {
                        if ( null != transformResponse )
                        {
                            censusMasterId = transformResponse.getCensusMasterId();
                            
                            //ignore below updates if no data returned from Transform_Ack_Build
                            if (censusMasterId > 1) {
                                censusAcknowledgementWork.sendCensusAcknowledgement( transformResponse );

                                //update 'ackFlag' status to 'SENT'
                                queryAckUpdate = session.getNamedQuery( OSP_TRANSFORM_ACK_COMPLETE )
                                                .setParameter( "censusMasterId", censusMasterId )
                                                .setParameter( "ackFlag", ACK_FLAG_SENT );
                                queryAckUpdate.list();
                                
                                if (tx.isActive())
                                {
                                    tx.commit();
                                }
                            }
                        }
                        else
                        {
                            LOGGER.error( ErrorCodeEnum.CENSUS_ACKNOWLEDGEMENT_RESPONSE_IS_NULL );
                            throw new CensusTransformAckException( ErrorCodeEnum.CENSUS_ACKNOWLEDGEMENT_RESPONSE_IS_NULL );
                        }
                    }
                    catch ( Exception e )
                    {
                        LOGGER.error( "Error in sending Acknowledgement " + e );

                        //update 'ackFlag' status to 'READY', so that it will be picked by another quartz job
                        queryAckUpdate = session.getNamedQuery( OSP_TRANSFORM_ACK_COMPLETE )
                                        .setParameter( "censusMasterId", censusMasterId )
                                        .setParameter( "ackFlag", ACK_FLAG_READY );
                        queryAckUpdate.list();
                    }
                }
            }
        }
        catch ( Exception e )
        {
            LOGGER.error( "Error in sendCensusTransformAcknowledgement" + e );
            throw new PersistenceException( ErrorCodeEnum.ERROR_IN_PERSISTENCE_LAYER, e );
        }
    }
}
