

package gov.va.med.cds.scheduler;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;

import gov.va.med.cds.exception.CensusTransformAckException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.scheduler.persistence.CensusTransformationAcknowledgementPersistenceInterface;


public abstract class AbstractCensusQuartzJobBean
    extends
        org.springframework.scheduling.quartz.QuartzJobBean
{
    private static Log logger = LogFactory.getLog( AbstractCensusQuartzJobBean.class );

    private static final String APPLICATION_CONTEXT_KEY = "applicationContext";

    protected ApplicationContext appCtx;

    protected void loadApplicationContext( JobExecutionContext context )
        throws CensusTransformAckException
    {
        try
        {
            appCtx = ( ApplicationContext )context.getScheduler().getContext().get( APPLICATION_CONTEXT_KEY );
        }
        catch ( SchedulerException e )
        {
            logger.error( "Error in loading mediator applicationContext into a quartz process" + e );
            throw new CensusTransformAckException( ErrorCodeEnum.UNABLE_TO_LOAD_MED_APP_CONTEXT, e );
        }

        if ( appCtx == null )
        {
            logger.error( ErrorCodeEnum.NULL_MED_APP_CONTEXT );
            throw new CensusTransformAckException( ErrorCodeEnum.NULL_MED_APP_CONTEXT );
        }
    }
}
