

package gov.va.med.cds.mediator.work.cds;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.TemplateInformation;
import gov.va.med.cds.mediator.work.WorkStateInterface;

import java.util.Map;


public class ClinicalDataCreateMessageWork
    extends
        AbstractClinicalDataServiceWork
{
    private Map<String, TemplateInformation> templateInformationMap;
    private String wsnClobNOTPersistedFlag;

    private boolean auditVhimRequest;


    public void doWork( WorkStateInterface workState )
    {

        if ( !workState.isWorkStateRegistered( this.wsnClobNOTPersistedFlag ) )
        {
            try
            {
                HL7SupportInterface hl7Support = getHL7SupportWorkState( workState );
                String sendingApplication = hl7Support.getSendingApplication();
                TemplateInformation templateInformation = templateInformationMap.get( sendingApplication );

                // CDS Create Clinical Data request parameters
                String request = getRequestWorkState( workState );
                String templateId = templateInformation.getTemplateName();
                String requestId = hl7Support.getMessageControlId();

                // make the request.
                String response = cdsSynchronous.createClinicalData( request, templateId, requestId, auditVhimRequest );

                // register the response with the work state
                setResponseWorkState( workState, response );
            }
            catch ( Exception e )
            {
                workState.addException( e );
            }
        }
        else
        {
            setResponseWorkState( workState, "Failure Persisting Audit Clob Store - Message was not sent to CDS for processing." );
        }
    }


    public void setWsnClobNOTPersistedFlag( String wsnClobNotPersistedFlag )
    {
        this.wsnClobNOTPersistedFlag = wsnClobNotPersistedFlag;
    }


    public void setTemplateInformationMap( Map<String, TemplateInformation> templateInformationMap )
    {
        this.templateInformationMap = templateInformationMap;
    }


    public void setAuditVhimRequest( boolean auditVhimRequest )
    {
        this.auditVhimRequest = auditVhimRequest;
    }

}
