

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.audit.LegacyReadAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;

import java.util.Date;


public class ReadRequestAuditLogEndWork
    implements
        WorkerInterface
{

    private String wsnHl7Support;
    private String wsnMessage;
    private String wsnCdsLegacyResponse;
    private String wsnStartTimeInMillis;
    private String wsnFilterInformation;

    private AuditLogPersistenceManagerInterface auditLogPersistenceManager;


    public void doWork( WorkStateInterface workState )
    {
        HL7SupportInterface hl7Support = null;
        String hl7Message = "";
        long startTimeInMillis = 0;
        String legacyResponse = "";

        try
        {
            hl7Support = ( HL7SupportInterface )workState.locateWorkState( this.wsnHl7Support );
            hl7Message = ( String )workState.locateWorkState( this.wsnMessage );
            startTimeInMillis = ( Long )workState.locateWorkState( this.wsnStartTimeInMillis );
            legacyResponse = ( String )workState.locateWorkState( wsnCdsLegacyResponse );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }
        finally
        {

            LegacyReadAuditLog auditLog = new LegacyReadAuditLog();
            auditLog.setEndTime( System.currentTimeMillis() );
            if ( hl7Support != null )
            {
                auditLog.setFacility( hl7Support.getStationNumber() );
                auditLog.setRequestId( hl7Support.getMessageControlId() );
                auditLog.setSendingApplication( hl7Support.getSendingApplication() );
            }
            auditLog.setLocalTime( new Date() );
            /*TODO JLA need template id and filter id client mapping*/
            FilterInformation filterInformation = ( FilterInformation )workState.locateWorkState( wsnFilterInformation );
            if ( filterInformation != null )
            {
                auditLog.setTemplateId( filterInformation.getTemplateId() );
                auditLog.setFilterId( filterInformation.getFilterId() );
            }
            auditLog.setFilterRequest( hl7Message );
            auditLog.setResponse( legacyResponse );
            auditLog.setStartTime( startTimeInMillis );

            auditLogPersistenceManager.storeAuditLog( auditLog );
        }

    }


    public void setWsnFilterInformation( String wsnFilterInformation )
    {
        this.wsnFilterInformation = wsnFilterInformation;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnMessage( String wsnMessage )
    {
        this.wsnMessage = wsnMessage;
    }


    public void setWsnCdsLegacyResponse( String wsnCdsLegacyResponse )
    {
        this.wsnCdsLegacyResponse = wsnCdsLegacyResponse;
    }


    public void setWsnStartTimeInMillis( String wsnStartTimeInMillis )
    {
        this.wsnStartTimeInMillis = wsnStartTimeInMillis;
    }


    public void setAuditLogPersistenceManager( AuditLogPersistenceManagerInterface auditLogPersistenceManager )
    {
        this.auditLogPersistenceManager = auditLogPersistenceManager;
    }
}
