

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;


public class AuditClobWork
    implements
        WorkerInterface
{
    private String wsnMessage;
    private String wsnHl7Support;
    private String wsnPersistFlag;
    private String wsnClobNOTPersistedFlag;
    private String wsnTemplateInformation;

    private CdsAuditClobStoreInterface cdsAuditClobStore;


    public void doWork( WorkStateInterface workState )
    {
        boolean persistMessage = ( Boolean )workState.locateWorkState( this.wsnPersistFlag );

        // check the persist flag to see if 
        // we're supposed to actually persist 
        // the messages.
        if ( persistMessage )
        {
            try
            {
                String hl7Message = ( String )workState.locateWorkState( this.wsnMessage );
                HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( this.wsnHl7Support );
                String sendingFacility = hl7Support.getSendingFacility();
                String requestId = hl7Support.getMessageControlId();
                String messageType = hl7Support.getSendingApplication();
                String updateDateTime = hl7Support.getMessageDateTime();
                TemplateInformation templateInformation = ( TemplateInformation )workState.locateWorkState( this.wsnTemplateInformation );
                String templateId = templateInformation.getTemplateName();

                CdsAuditClobStore auditClob = new CdsAuditClobStore( requestId, sendingFacility, hl7Message, updateDateTime, messageType, templateId );
                persistCdsAuditClob( auditClob );
            }
            catch ( Exception e )
            {
                //add a flag so future workers can determine action based on clob persist failure
                workState.registerWorkState( wsnClobNOTPersistedFlag, true );
                workState.addException( e );
            }
        }
    }


    public void setWsnMessage( String wsnMessage )
    {
        this.wsnMessage = wsnMessage;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnPersistFlag( String wsnPersistFlag )
    {
        this.wsnPersistFlag = wsnPersistFlag;
    }


    public void setWsnClobNOTPersistedFlag( String wsnClobNotPersistedFlag )
    {
        this.wsnClobNOTPersistedFlag = wsnClobNotPersistedFlag;
    }


    public void setWsnTemplateInformation( String wsnTemplateInformation )
    {
        this.wsnTemplateInformation = wsnTemplateInformation;
    }


    public void persistCdsAuditClob( CdsAuditClobStore auditClob )
    {
        //advice proxy configured around this object/method - new transaction to store clob
        this.cdsAuditClobStore.persistCdsAuditClob( auditClob );
    }


    public void setCdsAuditClobStore( CdsAuditClobStoreInterface cdsAuditClobStore )
    {
        this.cdsAuditClobStore = cdsAuditClobStore;
    }

}
