

package gov.va.med.cds.mediator.work;


import java.util.List;


public abstract class AbstractConditionalForkingWorkController
    implements
        WorkFlowInterface
{

    private List<WorkerInterface> trueFork;

    private List<WorkerInterface> falseFork;


    public void doWork( WorkStateInterface workState )
    {
        List<WorkerInterface> forkWork = evaluateCondition( workState ) ? trueFork : falseFork;

        for ( WorkerInterface work : forkWork )
        {
            try
            {
                work.doWork( workState );
            }
            catch ( Exception e )
            {
                workState.addException( e );
            }
        }
    }


    protected abstract boolean evaluateCondition( WorkStateInterface workState );


    public void setFalseFork( List<WorkerInterface> falseFork )
    {
        this.falseFork = falseFork;
    }


    public void setTrueFork( List<WorkerInterface> trueFork )
    {
        this.trueFork = trueFork;
    }

}
