

package gov.va.med.mediator.client.messagemediator;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;



@RunWith( SuiteAwareRunner.class )
public class MessageMediatorTest
{
    MessageMediatorInterface mediatorMock = null;


    @Before
    public void setUp( )
    {
        mediatorMock = new MessageMediatorMock();
    }


    /**
     * Tests the synchronous processMessage interface of Synchronous Mediator
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testAlive( )
    {
        Assert.assertTrue( mediatorMock.isAlive() );
    }


    /**
     * Tests the synchronous processMessage interface of Synchronous Mediator
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testProcessMessage( )
    {
        String hl7Request = "Some HL7 Message Request";

        String result = mediatorMock.processMessage( hl7Request );

        Assert.assertNotNull( result );
        Assert.assertTrue( result.length() > 0 );
    }

}