

package gov.va.med.mediator.client.messagemediator;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class MediatorExceptionTest
{

    private ErrorCodeEnum errorCode;
    private Throwable cause;
    private String[] customMsgValues;
    private MediatorException mediatorException;


    @Before
    @Suite( groups = "checkintest" )
    public void beforeMediatorExceptionTestMethodSetUp( )
        throws Exception
    {

        this.errorCode = null;
        this.cause = null;
        this.customMsgValues = null;
        this.mediatorException = null;
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testMediatorException1( )
        throws Exception
    {
        this.errorCode = ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION;
        assertNotNull( new MediatorException( errorCode ) );
        this.mediatorException = new MediatorException( errorCode );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testMediatorException2( )
        throws Exception
    {
        this.cause = new Throwable( "throwable1" );
        this.errorCode = ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION;
        assertNotNull( new MediatorException( errorCode, cause ) );
        this.mediatorException = new MediatorException( errorCode, cause );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testMediatorException3( )
        throws Exception
    {
        this.cause = null;
        this.errorCode = ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION;
        this.customMsgValues = new String[] { "customMsg1", "customMsg2", "customMsg3", "customMsg4", "customMsg5" };
        assertNotNull( new MediatorException( errorCode, customMsgValues ) );
        this.mediatorException = new MediatorException( errorCode, customMsgValues );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testMediatorException4( )
        throws Exception
    {
        this.cause = new Throwable( "throwable2" );
        this.errorCode = ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION;
        this.customMsgValues = new String[] { "customMsg1", "customMsg2", "customMsg3", "customMsg4", "customMsg5" };
        assertNotNull( new MediatorException( errorCode, cause, customMsgValues ) );
        this.mediatorException = new MediatorException( errorCode, cause, customMsgValues );
    }

}
