

package gov.va.med.cds.log4j;


import java.io.Serializable;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.springframework.context.ApplicationContext;



/**
 * 
 * This class is a Proxy to an AOP proxy for JMS Appender.  All calls upon this
 * class are passed on to a Spring configured AOP proxy of a RuntimeConfigurableAppender
 * 
 * @author DNS   TALBOM
 *
 */
@Plugin(name="SpringAwareAppenderProxy", category="Core", elementType="appender", printObject=true)
public class SpringAwareAppenderProxy
    extends
        AbstractSpringAwareProxy
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	//private AppenderInterface aopProxy;
	private AppenderInterface aopProxy;
	
	
	protected SpringAwareAppenderProxy(Filter filter, Layout<? extends Serializable> layout,String name, String springConfigResourceType,String configurations) {
		super(name, filter, layout, springConfigResourceType, configurations );
	}
	
	
/*	old log4j appender format
 * 	<appender name="JMS" class="gov.va.med.cds.log4j.SpringAwareAppenderProxy">
	<param name="springConfigResourceType" value="CLASSPATH" /> <!-- May be FILE or CLASSPATH only. -->
	<param name="springConfigurations" value="classpath:gov/va/med/cds/log4j/config/jms-app-logging-context.xml" />
	</appender>
*/
	@PluginFactory
	public static SpringAwareAppenderProxy createAppender(
			@PluginElement("Layout") Layout<? extends Serializable> layout,
			@PluginElement("Filter") final Filter filter,
			@PluginAttribute("name")String name,
			@PluginAttribute("springConfigResourceType")String resourceType,
			@PluginAttribute("springConfigurations")String configurations )
			
	{	
		
		return new SpringAwareAppenderProxy(filter, layout, name,resourceType,configurations);
	}
	
	
    
    @Override
	public void append(LogEvent logevent) {
    	if (aopProxy == null){
    		activateOptions();
    		if (aopProxy != null){
        		aopProxy.append( logevent );
        	}
    	}
    	else{
    		aopProxy.append( logevent );
    	}
	}
    
    @Override
    public void error(String msg, LogEvent event, Throwable t) {
		this.getHandler().error(msg, event, t);
		append(event);
	}

    @Override
	public void error(String msg, Throwable t) {
		this.getHandler().error(msg, t);
	}
    

  
    public void close( )
    {
        aopProxy.close();
    }


    public boolean requiresLayout( )
    {
        return false;
    }


    public void activateOptions( )
    {
         ApplicationContext appContext = getApplicationContext();
        if ( appContext != null )
        {
            this.aopProxy = ( AppenderInterface )appContext.getBean( "aop-proxy" );         
            aopProxy.activateOptions();
        }
    }


	
}