

package gov.va.med.cds.log4j;


//import org.apache.log4j.AppenderSkeleton;
import java.io.Serializable;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;


public abstract class AbstractSpringAwareProxy extends AbstractAppender
{

	protected enum SpringConfigResourceType { FILE, CLASSPATH };
    protected String[] springConfigurations;
    protected SpringConfigResourceType springConfigResourceType;
    
        /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected AbstractSpringAwareProxy(String name, Filter filter,
			Layout<? extends Serializable> layout, String springConfigResourceType, String configurations) {
		super(name, filter, layout);
		this.setSpringConfigResourceType(springConfigResourceType);
		this.setSpringConfigurations(configurations);
	}

    
    public AbstractSpringAwareProxy(String name, Filter filter,
			Layout<? extends Serializable> layout) {
    	super(name, filter, layout);
	}


	/**
     * 
     * @param springConfigurations
     */
    public void setSpringConfigurations(String springConfigurations) {
        this.springConfigurations = springConfigurations.split(",");
    }
    

    /**
     * 
     * @param springConfigResourceType
     */
    public void setSpringConfigResourceType( String springConfigResourceType) {
        this.springConfigResourceType = SpringConfigResourceType.valueOf(springConfigResourceType);
    }
    
    protected ApplicationContext getApplicationContext(){

        ApplicationContext appContext = null;
       
        switch ( springConfigResourceType )
        {
        case FILE:
            appContext = new FileSystemXmlApplicationContext(springConfigurations);
            break;
        case CLASSPATH:
        default:
            appContext = new ClassPathXmlApplicationContext(springConfigurations);
            break;
        }
        
        return appContext;
        
    }
}
