

package gov.va.med.cds.junit.runners;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation to mark methods that should belong to different types of test groups
 * Use the cds.test.groups environment variable to specify groups.</p> 
 * Example: <code> mvn clean install -Plocal <i>Dcds.test.groups=checkin</i></code></p>
 * This should look familiar.
 * 
 * @author vhaislsovar
 *
 */
@Retention( RetentionPolicy.RUNTIME )
@Target( ElementType.METHOD )
public @interface Suite {
    /**
     *  Property to filter tests based on group name
     */
    String[] groups() default {};


    /**
     * Property to order tests to run in order - to maintain dependancy.
     */
    int order() default 0;


    /**
     * Property used only for comments now, to clerify the dependency of tests on each other.
     */
    String[] dependsOnMethods() default {};
}
