

package gov.va.med.cds.hapi.extension.message;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.RDF;
import ca.uhn.hl7v2.model.v24.segment.RDT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import gov.va.med.cds.hapi.extension.CustomCdsModelClassFactory;


public class TBR_R08
    extends
        AbstractMessage
{

    /**
     * 
     */
    private static final long serialVersionUID = 1L;


    public TBR_R08( ModelClassFactory modelclassfactory )
    {
        super( modelclassfactory );
        init( modelclassfactory );
    }


    public TBR_R08( )
    {
        super( new CustomCdsModelClassFactory() );
        init( new CustomCdsModelClassFactory() );
    }


    private void init( ModelClassFactory modelclassfactory )
    {
        try
        {
            add( ca.uhn.hl7v2.model.v24.segment.MSH.class, true, false );
            add( ca.uhn.hl7v2.model.v24.segment.MSA.class, true, false );
            add( ca.uhn.hl7v2.model.v24.segment.ERR.class, false, true );
            add( ca.uhn.hl7v2.model.v24.segment.QAK.class, true, false );
            add( ca.uhn.hl7v2.model.v24.segment.RDF.class, true, false );
            add( ca.uhn.hl7v2.model.v24.segment.RDT.class, true, true );
            add( ca.uhn.hl7v2.model.v24.segment.DSC.class, false, false );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error(
                            "Unexpected error creating TBR_R08 - this is probably a bug in the source code generator.", hl7exception );
        }
    }


    public MSH getMSH( )
    {
        MSH msh = null;
        try
        {
            msh = ( MSH )get( "MSH" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return msh;
    }


    public MSA getMSA( )
    {
        MSA msa = null;
        try
        {
            msa = ( MSA )get( "MSA" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return msa;
    }


    public ERR getERR( )
    {
        ERR err = null;
        try
        {
            err = ( ERR )get( "ERR" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return err;
    }


    public ERR getERR( int i )
        throws HL7Exception
    {
        return ( ERR )get( "ERR", i );
    }


    public int getERRReps( )
    {
        int i = -1;
        try
        {
            i = getAll( "ERR" ).length;
        }
        catch ( HL7Exception hl7exception )
        {
            String s = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( getClass() ).error( s, hl7exception );
            throw new RuntimeException( s );
        }
        return i;
    }


    public QAK getQAK( )
    {
        QAK qak = null;
        try
        {
            qak = ( QAK )get( "QAK" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return qak;
    }


    public RDF getRDF( )
    {
        RDF rdf = null;
        try
        {
            rdf = ( RDF )get( "RDF" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return rdf;
    }


    public RDT getRDT( )
    {
        RDT rdt = null;
        try
        {
            rdt = ( RDT )get( "RDT" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return rdt;
    }


    public RDT getRDT( int i )
        throws HL7Exception
    {
        return ( RDT )get( "RDT", i );
    }


    public int getRDTReps( )
    {
        int i = -1;
        try
        {
            i = getAll( "RDT" ).length;
        }
        catch ( HL7Exception hl7exception )
        {
            String s = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( getClass() ).error( s, hl7exception );
            throw new RuntimeException( s );
        }
        return i;
    }


    public DSC getDSC( )
    {
        DSC dsc = null;
        try
        {
            dsc = ( DSC )get( "DSC" );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return dsc;
    }

}
