

package gov.va.med.cds.hapi.extension.message;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.CTD;
import ca.uhn.hl7v2.model.v24.segment.CTI;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;


// Custom class for segment group containing custom OBR segment.
// Also contains Lab specific OBSERVATION group.

/**
 * <p>
 * Represents the ORU_R01_ORDER_OBSERVATION Group. A Group is an ordered collection of message segments that can repeat
 * together or be optionally in/excluded together. This Group contains the following elements:
 * </p>
 * 0: ORC (Common Order) <b>optional </b><br>
 * 1: OBR (Observation Request) <b></b><br>
 * 2: NTE (Notes and Comments) <b>optional repeating</b><br>
 * 3: CTD (Contact Data) <b>optional </b><br>
 * 4: ORU_R01_OBSERVATION (a Group object) <b>repeating</b><br>
 * 5: FT1 (Financial Transaction) <b>optional repeating</b><br>
 * 6: CTI (Clinical Trial Identification) <b>optional repeating</b><br>
 */
public class ORU_R01_ORDER_OBSERVATION
    extends
        AbstractGroup
{

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/**
     * Creates a new ORU_R01_ORDER_OBSERVATION Group.
     */
    public ORU_R01_ORDER_OBSERVATION( Group parent, ModelClassFactory factory )
    {
        super( parent, factory );
        try
        {
            this.add( gov.va.med.cds.hapi.extension.segment.ORC.class, false, false );
            this.add( gov.va.med.cds.hapi.extension.segment.OBR.class, true, false );
            this.add( NTE.class, false, true );
            this.add( CTD.class, false, false );
            this.add( ORU_R01_OBSERVATION.class, true, true );
            this.add( FT1.class, false, true );
            this.add( CTI.class, false, true );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error creating ORU_R01_ORDER_OBSERVATION - this is probably a bug in the source code generator.", e );
        }
    }


    /**
     * Returns ORC (Common Order) - creates it if necessary
     */
    public ORC getORC( )
    {
        ORC ret = null;
        try
        {
            ret = ( ORC )this.get( "ORC" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns OBR (Observation Request) - creates it if necessary
     */
    public gov.va.med.cds.hapi.extension.segment.OBR getOBR( )
    {
        gov.va.med.cds.hapi.extension.segment.OBR ret = null;
        try
        {
            ret = ( gov.va.med.cds.hapi.extension.segment.OBR )this.get( "OBR" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns first repetition of NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE( )
    {
        NTE ret = null;
        try
        {
            ret = ( NTE )this.get( "NTE" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of NTE (Notes and Comments) - creates it if necessary throws HL7Exception if the
     * repetition requested is more than one greater than the number of existing repetitions.
     */
    public NTE getNTE( int rep )
        throws HL7Exception
    {
        return ( NTE )this.get( "NTE", rep );
    }


    /**
     * Returns the number of existing repetitions of NTE
     */
    public int getNTEReps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "NTE" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }


    /**
     * Returns CTD (Contact Data) - creates it if necessary
     */
    public CTD getCTD( )
    {
        CTD ret = null;
        try
        {
            ret = ( CTD )this.get( "CTD" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns first repetition of ORU_R01_OBSERVATION (a Group object) - creates it if necessary
     */
    public ORU_R01_OBSERVATION getOBSERVATION( )
    {
        ORU_R01_OBSERVATION ret = null;
        try
        {
            ret = ( ORU_R01_OBSERVATION )this.get( "OBSERVATION" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of ORU_R01_OBSERVATION (a Group object) - creates it if necessary throws
     * HL7Exception if the repetition requested is more than one greater than the number of existing repetitions.
     */
    public ORU_R01_OBSERVATION getOBSERVATION( int rep )
        throws HL7Exception
    {
        return ( ORU_R01_OBSERVATION )this.get( "OBSERVATION", rep );
    }


    /**
     * Returns the number of existing repetitions of ORU_R01_OBSERVATION
     */
    public int getOBSERVATIONReps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "OBSERVATION" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }


    /**
     * Returns first repetition of FT1 (Financial Transaction) - creates it if necessary
     */
    public FT1 getFT1( )
    {
        FT1 ret = null;
        try
        {
            ret = ( FT1 )this.get( "FT1" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of FT1 (Financial Transaction) - creates it if necessary throws HL7Exception if the
     * repetition requested is more than one greater than the number of existing repetitions.
     */
    public FT1 getFT1( int rep )
        throws HL7Exception
    {
        return ( FT1 )this.get( "FT1", rep );
    }


    /**
     * Returns the number of existing repetitions of FT1
     */
    public int getFT1Reps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "FT1" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }


    /**
     * Returns first repetition of CTI (Clinical Trial Identification) - creates it if necessary
     */
    public CTI getCTI( )
    {
        CTI ret = null;
        try
        {
            ret = ( CTI )this.get( "CTI" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of CTI (Clinical Trial Identification) - creates it if necessary throws
     * HL7Exception if the repetition requested is more than one greater than the number of existing repetitions.
     */
    public CTI getCTI( int rep )
        throws HL7Exception
    {
        return ( CTI )this.get( "CTI", rep );
    }


    /**
     * Returns the number of existing repetitions of CTI
     */
    public int getCTIReps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "CTI" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }
}
