

package gov.va.med.cds.hapi.extension.message;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import gov.va.med.cds.hapi.extension.segment.OBX;


public class ORU_R01_OBSERVATION
    extends
        AbstractGroup
{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/**
     * Creates a new ORU_R01_OBSERVATION Group.
     */
    public ORU_R01_OBSERVATION( Group parent, ModelClassFactory factory )
    {
        super( parent, factory );
        try
        {
            this.add( gov.va.med.cds.hapi.extension.segment.OBX.class, false, false );
            this.add( NTE.class, false, true );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error creating ORU_R01_OBSERVATION - this is probably a bug in the source code generator.", e );
        }
    }


    /**
     * Returns OBX (Observation/Result) - creates it if necessary
     */
    public OBX getOBX( )
    {
        OBX ret = null;
        try
        {
            ret = ( OBX )this.get( "OBX" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns first repetition of NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE( )
    {
        NTE ret = null;
        try
        {
            ret = ( NTE )this.get( "NTE" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns a specific repetition of NTE (Notes and Comments) - creates it if necessary throws HL7Exception if the
     * repetition requested is more than one greater than the number of existing repetitions.
     */
    public NTE getNTE( int rep )
        throws HL7Exception
    {
        return ( NTE )this.get( "NTE", rep );
    }


    /**
     * Returns the number of existing repetitions of NTE
     */
    public int getNTEReps( )
    {
        int reps = -1;
        try
        {
            reps = this.getAll( "NTE" ).length;
        }
        catch ( HL7Exception e )
        {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LogFactory.getLog( this.getClass() ).error( message, e );
            throw new RuntimeException( message );
        }
        return reps;
    }
}
