

package gov.va.med.cds.hapi.extension.group;

import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.RXE;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;


public class CustomRDEGroup
    extends
        AbstractGroup
{

    private static final long serialVersionUID = 1L;


    protected CustomRDEGroup( Group parent, ModelClassFactory factory )
    {
        super( parent, factory );
        try
        {
            this.add( MSH.class, true, false );
            this.add( PID.class, true, false );
            this.add( ORC.class, false, false );
            this.add( RXE.class, false, true );
            this.add( RXR.class, false, true );
            this.add( FT1.class, false, true );
            this.add( OBX.class, true, true );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error creating RDE_O11 - this is probably a bug in the source code generator.", e );
        }
    }
}
